/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ConversationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.jboss.seam.logging.Logger;
import org.jboss.seam.persistence.FlushModeManager;
import org.jboss.seam.persistence.FlushModeType;
import org.jboss.seam.persistence.ManagedPersistenceContext;
import org.jboss.seam.persistence.PersistenceContexts;

@ConversationScoped
public class PersistenceContextsImpl
implements Serializable,
PersistenceContexts {
    private static final long serialVersionUID = -4897350516435283182L;
    private static final Logger log = Logger.getLogger(PersistenceContextsImpl.class);
    private final Set<PersistenceContextDefintition> set = new HashSet<PersistenceContextDefintition>();
    private FlushModeType flushMode;
    private FlushModeType realFlushMode;
    @Inject
    @Any
    private Instance<ManagedPersistenceContext> persistenceContexts;

    @Inject
    public void create(FlushModeManager manager) {
        FlushModeType defaultFlushMode = manager.getFlushModeType();
        this.flushMode = defaultFlushMode != null ? defaultFlushMode : FlushModeType.AUTO;
    }

    public FlushModeType getFlushMode() {
        return this.flushMode;
    }

    public Set<PersistenceContextDefintition> getTouchedContexts() {
        return Collections.unmodifiableSet(this.set);
    }

    public void touch(ManagedPersistenceContext context) {
        this.set.add(new PersistenceContextDefintition(context.getQualifiers(), context.getBeanType()));
    }

    public void untouch(ManagedPersistenceContext context) {
        this.set.remove(new PersistenceContextDefintition(context.getQualifiers(), context.getBeanType()));
    }

    public void changeFlushMode(FlushModeType flushMode) {
        this.flushMode = flushMode;
        this.changeFlushModes();
    }

    public void restoreFlushMode() {
        if (this.realFlushMode != null && this.realFlushMode != this.flushMode) {
            this.flushMode = this.realFlushMode;
            this.realFlushMode = null;
            this.changeFlushModes();
        }
    }

    private void changeFlushModes() {
        for (ManagedPersistenceContext context : this.persistenceContexts) {
            if (!this.set.contains(new PersistenceContextDefintition(context.getQualifiers(), context.getBeanType()))) continue;
            try {
                context.changeFlushMode(this.flushMode);
            }
            catch (UnsupportedOperationException uoe) {
                log.warn((Object)uoe.getMessage());
            }
        }
    }

    public void beforeRender() {
        for (ManagedPersistenceContext context : this.persistenceContexts) {
            if (!this.set.contains(new PersistenceContextDefintition(context.getQualifiers(), context.getBeanType()))) continue;
            try {
                context.changeFlushMode(context.getProvider().getRenderFlushMode());
            }
            catch (UnsupportedOperationException uoe) {
                log.warn((Object)uoe.getMessage());
            }
        }
    }

    public void afterRender() {
        this.restoreFlushMode();
    }

    public static class PersistenceContextDefintition {
        private final Set<Annotation> qualifiers;
        private final Class<?> type;

        public PersistenceContextDefintition(Set<Annotation> qualifiers, Class<?> type) {
            this.qualifiers = new HashSet<Annotation>(qualifiers);
            this.type = type;
        }

        public Set<Annotation> getQualifiers() {
            return this.qualifiers;
        }

        public Class<?> getType() {
            return this.type;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.qualifiers == null ? 0 : ((Object)this.qualifiers).hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PersistenceContextDefintition other = (PersistenceContextDefintition)obj;
            if (this.qualifiers == null ? other.qualifiers != null : !((Object)this.qualifiers).equals(other.qualifiers)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

