/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence.hibernate;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Alternative;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AnnotatedCallable;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.seam.logging.Logger;
import org.jboss.seam.persistence.HibernatePersistenceProvider;
import org.jboss.seam.persistence.ManagedPersistenceContext;
import org.jboss.seam.persistence.hibernate.HibernateExtension;
import org.jboss.seam.persistence.hibernate.HibernateManagedSessionBeanLifecycle;
import org.jboss.seam.persistence.hibernate.HibernateManagedSessionExtension;
import org.jboss.seam.solder.bean.BeanBuilder;
import org.jboss.seam.solder.bean.ContextualLifecycle;
import org.jboss.seam.solder.core.ExtensionManaged;
import org.jboss.seam.solder.core.Veto;
import org.jboss.seam.solder.literal.AnyLiteral;
import org.jboss.seam.solder.literal.ApplicationScopedLiteral;
import org.jboss.seam.solder.literal.DefaultLiteral;
import org.jboss.seam.solder.reflection.annotated.AnnotatedTypeBuilder;
import org.jboss.seam.solder.reflection.annotated.Annotateds;

@Veto
public class HibernateManagedSessionExtensionImpl
implements HibernateExtension {
    Set<Bean<?>> beans = new HashSet();
    private static final Logger log = Logger.getLogger(HibernateManagedSessionExtensionImpl.class);
    private static final HibernatePersistenceProvider persistenceProvider = new HibernatePersistenceProvider();

    @Override
    public <T> void processAnnotatedType(@Observes ProcessAnnotatedType<T> event, BeanManager manager) {
        AnnotatedTypeBuilder modifiedType = null;
        for (AnnotatedMethod method : event.getAnnotatedType().getMethods()) {
            if (!method.isAnnotationPresent(ExtensionManaged.class) || !method.isAnnotationPresent(Produces.class) || !SessionFactory.class.isAssignableFrom(method.getJavaMember().getReturnType())) continue;
            if (modifiedType == null) {
                modifiedType = new AnnotatedTypeBuilder().readFromType(event.getAnnotatedType());
            }
            HashSet<Annotation> qualifiers = new HashSet<Annotation>();
            Class scope = Dependent.class;
            for (Annotation annotation : method.getAnnotations()) {
                if (manager.isQualifier(annotation.annotationType())) {
                    qualifiers.add(annotation);
                    continue;
                }
                if (!manager.isScope(annotation.annotationType())) continue;
                scope = annotation.annotationType();
            }
            if (qualifiers.isEmpty()) {
                qualifiers.add((Annotation)new DefaultLiteral());
            }
            qualifiers.add((Annotation)AnyLiteral.INSTANCE);
            modifiedType.removeFromMethod(method.getJavaMember(), scope);
            modifiedType.addToMethod(method.getJavaMember(), (Annotation)ApplicationScopedLiteral.INSTANCE);
            this.registerManagedSession((Set<Annotation>)qualifiers, scope, method.isAnnotationPresent(Alternative.class), manager, event.getAnnotatedType().getJavaClass().getClassLoader(), (AnnotatedMember<?>)method, event.getAnnotatedType().getJavaClass());
            log.info((Object)("Configuring Seam Managed Hibernate Session from producer method " + event.getAnnotatedType().getJavaClass().getName() + "." + method.getJavaMember().getName() + " with qualifiers " + qualifiers));
        }
        if (modifiedType != null) {
            event.setAnnotatedType(modifiedType.create());
        }
    }

    private void registerManagedSession(Set<Annotation> qualifiers, Class<? extends Annotation> scope, boolean alternative, BeanManager manager, ClassLoader loader, AnnotatedMember<?> member, Class<?> declaringClass) {
        HibernateManagedSessionBeanLifecycle lifecycle = new HibernateManagedSessionBeanLifecycle(qualifiers, loader, manager);
        AnnotatedTypeBuilder typeBuilder = new AnnotatedTypeBuilder().setJavaClass(Session.class);
        BeanBuilder builder = new BeanBuilder(manager).readFromType(typeBuilder.create());
        builder.qualifiers(qualifiers);
        builder.scope(scope);
        builder.beanClass(member.getDeclaringType().getJavaClass());
        builder.getTypes().add(ManagedPersistenceContext.class);
        builder.getTypes().addAll(persistenceProvider.getAdditionalSessionInterfaces());
        builder.getTypes().add(Object.class);
        builder.beanLifecycle((ContextualLifecycle)lifecycle);
        builder.alternative(alternative);
        StringBuilder id = new StringBuilder("SMHS-" + HibernateManagedSessionExtension.class.getName() + "-");
        if (member instanceof AnnotatedField) {
            AnnotatedField field = (AnnotatedField)member;
            id.append(Annotateds.createFieldId((AnnotatedField)field));
        } else {
            AnnotatedCallable method = (AnnotatedCallable)member;
            id.append(Annotateds.createCallableId((AnnotatedCallable)method));
        }
        builder.id(id.toString());
        builder.passivationCapable(true);
        builder.toString("Seam Managed Hibernate Session with qualifiers [" + qualifiers + "] with configured by [" + member + "] on class [" + declaringClass + "]");
        this.beans.add(builder.create());
    }

    @Override
    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event) {
        for (Bean<?> i : this.beans) {
            event.addBean(i);
        }
    }
}

