/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.persistence;

import java.io.Serializable;
import java.lang.reflect.Method;
import javax.enterprise.inject.spi.BeanManager;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.jboss.seam.persistence.QueryParser;
import org.jboss.seam.persistence.util.InstanceResolver;
import org.jboss.solder.el.Expressions;
import org.jboss.solder.logging.Logger;

public class PersistenceContextProxyHandler
implements Serializable {
    private static final long serialVersionUID = -6539267789786229774L;
    private final EntityManager delegate;
    private transient Expressions expressions;
    private final BeanManager beanManager;
    private static final Logger log = Logger.getLogger(PersistenceContextProxyHandler.class);

    public PersistenceContextProxyHandler(EntityManager delegate, BeanManager beanManager) {
        this.delegate = delegate;
        this.beanManager = beanManager;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("createQuery".equals(method.getName()) && method.getParameterTypes().length > 0 && method.getParameterTypes()[0].equals(String.class)) {
            return this.handleCreateQueryWithString(method, args);
        }
        return method.invoke((Object)this.delegate, args);
    }

    protected Object handleCreateQueryWithString(Method method, Object[] args) throws Throwable {
        if (args[0] == null) {
            return method.invoke((Object)this.delegate, args);
        }
        String ejbql = (String)args[0];
        if (ejbql.indexOf(35) > 0) {
            Expressions expressions = this.getExpressions();
            QueryParser qp = new QueryParser(expressions, ejbql);
            Object[] newArgs = (Object[])args.clone();
            newArgs[0] = qp.getEjbql();
            Query query = (Query)method.invoke((Object)this.delegate, newArgs);
            for (int i = 0; i < qp.getParameterValues().size(); ++i) {
                query.setParameter(QueryParser.getParameterName(i), qp.getParameterValues().get(i));
            }
            return query;
        }
        return method.invoke((Object)this.delegate, args);
    }

    private Expressions getExpressions() {
        if (this.expressions == null) {
            this.expressions = (Expressions)InstanceResolver.getInstance(Expressions.class, this.beanManager).get();
        }
        return this.expressions;
    }
}

