/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.render.template.resolver;

import org.jboss.seam.render.spi.TemplateResolver;
import org.jboss.seam.render.spi.TemplateResource;
import org.jboss.seam.render.template.resolver.ClassLoaderTemplateResource;
import org.jboss.seam.render.util.Assert;
import org.jboss.seam.render.util.Paths;

public class ClassLoaderTemplateResolver
implements TemplateResolver<ClassLoader> {
    private final ClassLoader loader;

    public ClassLoaderTemplateResolver() {
        this.loader = this.getClass().getClassLoader();
    }

    public ClassLoaderTemplateResolver(ClassLoader loader) {
        Assert.notNull(loader, "ClassLoader must not be null.");
        this.loader = loader;
    }

    @Override
    public TemplateResource<ClassLoader> resolve(String path) {
        Assert.notNull(path, "Resource path must not be null.");
        if (this.isValid(path)) {
            return new ClassLoaderTemplateResource(this, this.loader, path);
        }
        return null;
    }

    @Override
    public TemplateResource<ClassLoader> resolveRelative(TemplateResource<ClassLoader> origin, String relativePath) {
        Assert.notNull(origin, "Origin resource must not be null.");
        Assert.notNull(relativePath, "Relative resource path must not be null.");
        String path = origin.getPath();
        path = Paths.calculateRelativePath(path, relativePath);
        if (this.isValid(path)) {
            return new ClassLoaderTemplateResource(this, this.loader, path);
        }
        return null;
    }

    private boolean isValid(String target) {
        return this.loader.getResource(target) != null;
    }
}

