/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.example.tasks.resource;

import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.seam.rest.example.tasks.entity.Category;
import org.jboss.seam.rest.example.tasks.resource.CollectionBean;
import org.jboss.seam.rest.templating.ResponseTemplate;
import org.jboss.seam.rest.validation.ValidateRequest;

@Path(value="/category")
@RequestScoped
@Named
public class CategoryCollectionResource {
    @Inject
    private CollectionBean bean;
    @QueryParam(value="start")
    @DefaultValue(value="0")
    @Min(value=0L, message="start must be a non-negative number")
    protected int start;
    @QueryParam(value="limit")
    @DefaultValue(value="5")
    @Min(value=0L, message="limit must be a non-negative number")
    @Max(value=100L, message="Cannot return more than 100 items")
    protected int limit;
    @Context
    protected UriInfo uriInfo;

    @GET
    @ValidateRequest
    @Produces(value={"application/json", "application/categories+xml", "application/categories-short+xml"})
    @ResponseTemplate.List(value={@ResponseTemplate(value="/freemarker/categories.ftl", produces="application/categories+xml"), @ResponseTemplate(value="/freemarker/categories-short.ftl", produces="application/categories-short+xml")})
    public List<Category> getCategories() {
        return this.bean.getCategories(this.start, this.limit);
    }

    public int getStart() {
        return this.start;
    }

    public int getLimit() {
        return this.limit;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

