/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.example.tasks.resource;

import java.util.List;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.inject.Named;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.Pattern;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import org.jboss.seam.rest.example.tasks.entity.Task;
import org.jboss.seam.rest.example.tasks.resource.CollectionBean;
import org.jboss.seam.rest.example.tasks.resource.TaskResource;
import org.jboss.seam.rest.templating.ResponseTemplate;
import org.jboss.seam.rest.validation.ValidateRequest;

@Path(value="/task")
@RequestScoped
@Named
public class TaskCollectionResource {
    @Inject
    private CollectionBean bean;
    @Inject
    private TaskResource taskSubresource;
    @Context
    protected UriInfo uriInfo;
    @QueryParam(value="start")
    @DefaultValue(value="0")
    @Min(value=0L, message="start must be a non-negative number")
    protected int start;
    @QueryParam(value="limit")
    @DefaultValue(value="5")
    @Min(value=0L, message="limit must be a non-negative number")
    @Max(value=100L, message="Cannot return more than 100 items")
    protected int limit;
    @Pattern(regexp="resolved|unresolved|all", message="Unknown task status. Allowed values: resolved, unresolved, all")
    private String status;

    @GET
    @ValidateRequest
    @Produces(value={"application/tasks+xml", "application/json"})
    @ResponseTemplate(value="/freemarker/tasks.ftl", produces="application/tasks+xml")
    public List<Task> getTasks() {
        return this.bean.getTasks(this.start, this.limit, this.status, (String)this.uriInfo.getPathParameters().getFirst((Object)"category"));
    }

    @Path(value="/{taskId}")
    public TaskResource getTaskSubresource() {
        return this.taskSubresource;
    }

    @QueryParam(value="status")
    @DefaultValue(value="unresolved")
    public void setStatus(String status) {
        this.status = status;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public int getStart() {
        return this.start;
    }

    public int getLimit() {
        return this.limit;
    }
}

