/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest;

import java.lang.annotation.Annotation;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import org.jboss.logging.Logger;
import org.jboss.seam.rest.client.RestClient;
import org.jboss.seam.rest.exceptions.ErrorMessageWrapper;
import org.jboss.seam.rest.exceptions.ExceptionMapping;
import org.jboss.seam.rest.exceptions.ExceptionMappingConfiguration;
import org.jboss.seam.rest.exceptions.PlainTextExceptionMapping;
import org.jboss.seam.rest.exceptions.ResponseBuilderProducer;
import org.jboss.seam.rest.exceptions.RestRequest;
import org.jboss.seam.rest.exceptions.RestResource;
import org.jboss.seam.rest.exceptions.SeamExceptionMapper;
import org.jboss.seam.rest.exceptions.integration.CatchExceptionMapper;
import org.jboss.seam.rest.exceptions.integration.CatchValidationExceptionHandler;
import org.jboss.seam.rest.templating.TemplatingModel;
import org.jboss.seam.rest.util.ExpressionLanguageInterpolator;
import org.jboss.seam.rest.util.Interpolator;
import org.jboss.seam.rest.util.Utils;
import org.jboss.seam.rest.validation.ValidateRequest;
import org.jboss.seam.rest.validation.ValidationExceptionHandler;
import org.jboss.seam.rest.validation.ValidationInterceptor;
import org.jboss.seam.rest.validation.ValidationMetadata;

public class SeamRestExtension
implements Extension {
    private static final Logger log = Logger.getLogger(SeamRestExtension.class);
    private static final String SEAM_CATCH_NAME = "org.jboss.seam.exception.control.extension.CatchExtension";
    private boolean catchIntegrationEnabled = false;

    void registerSeamRest(@Observes BeforeBeanDiscovery event, BeanManager manager) {
        log.info((Object)"Seam REST Extension starting...");
        this.catchIntegrationEnabled = Utils.isClassAvailable(SEAM_CATCH_NAME);
        event.addQualifier(RestClient.class);
        event.addQualifier(RestRequest.class);
        event.addQualifier(RestResource.class);
        event.addInterceptorBinding(ValidateRequest.class, new Annotation[0]);
        event.addAnnotatedType(manager.createAnnotatedType(ExceptionMapping.class));
        event.addAnnotatedType(manager.createAnnotatedType(ExceptionMappingConfiguration.class));
        event.addAnnotatedType(manager.createAnnotatedType(PlainTextExceptionMapping.class));
        event.addAnnotatedType(manager.createAnnotatedType(TemplatingModel.class));
        event.addAnnotatedType(manager.createAnnotatedType(Interpolator.class));
        event.addAnnotatedType(manager.createAnnotatedType(ExpressionLanguageInterpolator.class));
        event.addAnnotatedType(manager.createAnnotatedType(ValidationInterceptor.class));
        event.addAnnotatedType(manager.createAnnotatedType(ValidationMetadata.class));
        event.addAnnotatedType(manager.createAnnotatedType(ValidationExceptionHandler.class));
        if (!this.catchIntegrationEnabled) {
            event.addAnnotatedType(manager.createAnnotatedType(SeamExceptionMapper.class));
        }
        event.addAnnotatedType(manager.createAnnotatedType(ErrorMessageWrapper.class));
        event.addAnnotatedType(manager.createAnnotatedType(ResponseBuilderProducer.class));
        if (this.catchIntegrationEnabled) {
            log.info((Object)"Catch integration enabled.");
            event.addAnnotatedType(manager.createAnnotatedType(CatchExceptionMapper.class));
            event.addAnnotatedType(manager.createAnnotatedType(CatchValidationExceptionHandler.class));
        }
    }

    public boolean isCatchIntegrationEnabled() {
        return this.catchIntegrationEnabled;
    }
}

