/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.exceptions;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.jboss.logging.Logger;
import org.jboss.seam.rest.exceptions.ErrorMessageWrapper;
import org.jboss.seam.rest.exceptions.ExceptionMapping;
import org.jboss.seam.rest.exceptions.ExceptionMappingConfiguration;
import org.jboss.seam.rest.exceptions.PlainTextExceptionMapping;
import org.jboss.seam.rest.exceptions.RestResource;
import org.jboss.seam.rest.exceptions.UnhandledException;
import org.jboss.seam.rest.util.Interpolator;
import org.jboss.seam.rest.validation.ValidationException;
import org.jboss.seam.rest.validation.ValidationExceptionHandler;
import org.jboss.seam.servlet.event.Initialized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@ApplicationScoped
public class SeamExceptionMapper
implements ExceptionMapper<Throwable> {
    @Inject
    @RestResource
    private Response.ResponseBuilder responseBuilder;
    @Inject
    @RestResource
    private Instance<Response> response;
    @Inject
    private Interpolator interpolator;
    @Inject
    private ValidationExceptionHandler validationExceptionHandler;
    private Map<Class<? extends Throwable>, ExceptionMapping> mappings = new HashMap<Class<? extends Throwable>, ExceptionMapping>();
    private static final Logger log = Logger.getLogger(SeamExceptionMapper.class);

    @Inject
    public void init(ExceptionMappingConfiguration configuration) {
        log.info((Object)"Processing exception mapping configuration.");
        for (ExceptionMapping mapping : configuration.getExceptionMappings()) {
            this.mappings.put(mapping.getExceptionType(), mapping);
            log.infov("Registered {0}", (Object)mapping);
        }
    }

    public void init(@Observes @Initialized ServletContext ctx) {
    }

    public Response toResponse(Throwable e) {
        log.debugv("Handling {0}", e.getClass());
        for (Throwable exception = e; exception != null; exception = exception.getCause()) {
            Class<?> exceptionType = exception.getClass();
            if (this.mappings.containsKey(exceptionType)) {
                this.produceResponse(exception, this.responseBuilder);
                return (Response)this.response.get();
            }
            if (exception instanceof ValidationException) {
                this.validationExceptionHandler.handleValidationException((ValidationException)exception, this.responseBuilder);
                return (Response)this.response.get();
            }
            log.debugv("Unwrapping {0}", exception.getClass());
        }
        throw new UnhandledException(e);
    }

    protected void produceResponse(Throwable exception, Response.ResponseBuilder builder) {
        ExceptionMapping mapping = this.mappings.get(exception.getClass());
        log.debugv("Found exception mapping {0} for {1}", (Object)mapping, exception.getClass());
        builder.status(mapping.getStatusCode());
        if (mapping.getMessage() != null) {
            builder.entity(this.createEntityBody(mapping));
        }
    }

    protected Object createEntityBody(ExceptionMapping mapping) {
        if (mapping instanceof PlainTextExceptionMapping) {
            return this.getInterpolatedMessage(mapping);
        }
        return new ErrorMessageWrapper(this.getInterpolatedMessage(mapping));
    }

    private String getInterpolatedMessage(ExceptionMapping mapping) {
        if (mapping.isInterpolateMessageBody()) {
            return this.interpolator.interpolate(mapping.getMessage());
        }
        return mapping.getMessage();
    }

    public Map<Class<? extends Throwable>, ExceptionMapping> getMappings() {
        return this.mappings;
    }
}

