/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.exceptions.integration;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.jboss.logging.Logger;
import org.jboss.seam.exception.control.CaughtException;
import org.jboss.seam.exception.control.ExceptionToCatch;
import org.jboss.seam.exception.control.Handles;
import org.jboss.seam.exception.control.HandlesExceptions;
import org.jboss.seam.exception.control.TraversalPath;
import org.jboss.seam.rest.exceptions.RestRequest;
import org.jboss.seam.rest.exceptions.RestResource;
import org.jboss.seam.rest.exceptions.SeamExceptionMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
@HandlesExceptions
public class CatchExceptionMapper
extends SeamExceptionMapper
implements ExceptionMapper<Throwable> {
    @Inject
    @RestResource
    private Instance<Response> response;
    @Inject
    private Event<ExceptionToCatch> bridgeEvent;
    private static final Logger log = Logger.getLogger(CatchExceptionMapper.class);

    @Override
    public Response toResponse(Throwable exception) {
        ExceptionToCatch payload = new ExceptionToCatch(exception, new Annotation[]{RestRequest.RestRequestLiteral.INSTANCE});
        this.bridgeEvent.fire((Object)payload);
        return (Response)this.response.get();
    }

    public void handleException(@Handles(precedence=-100, during=TraversalPath.DESCENDING) @RestRequest CaughtException<Throwable> event, @RestResource Response.ResponseBuilder builder) {
        Class<?> exceptionType = event.getException().getClass();
        log.debugv("Handling {0}", exceptionType);
        if (this.getMappings().containsKey(exceptionType)) {
            this.produceResponse(event.getException(), builder);
            event.handled();
        } else {
            event.rethrow();
            event.unmute();
        }
    }
}

