/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.templating;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import org.jboss.logging.Logger;
import org.jboss.seam.rest.templating.TemplatingMessageBodyWriter;
import org.jboss.seam.rest.templating.freemarker.FreeMarkerProvider;
import org.jboss.seam.rest.templating.velocity.VelocityModel;
import org.jboss.seam.rest.templating.velocity.VelocityProvider;
import org.jboss.seam.rest.util.Utils;

public class TemplatingExtension
implements Extension {
    private static final String FREEMARKER_TEMPLATE_CLASS_NAME = "freemarker.template.Template";
    private static final String VELOCITY_TEMPLATE_CLASS_NAME = "org.apache.velocity.Template";
    private static final Logger log = Logger.getLogger(TemplatingExtension.class);

    public void registerExtension(@Observes BeforeBeanDiscovery event, BeanManager manager) {
        boolean freemarkerEnabled = Utils.isClassAvailable(FREEMARKER_TEMPLATE_CLASS_NAME);
        boolean velocityEnabled = Utils.isClassAvailable(VELOCITY_TEMPLATE_CLASS_NAME);
        if (freemarkerEnabled) {
            log.debug((Object)"FreeMarker found on classpath, adding support beans.");
            event.addAnnotatedType(manager.createAnnotatedType(FreeMarkerProvider.class));
        }
        if (velocityEnabled) {
            log.debug((Object)"Velocity found on classpath, adding support beans.");
            event.addAnnotatedType(manager.createAnnotatedType(VelocityModel.class));
            event.addAnnotatedType(manager.createAnnotatedType(VelocityProvider.class));
        }
        event.addAnnotatedType(manager.createAnnotatedType(TemplatingMessageBodyWriter.class));
    }
}

