/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.templating;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.jboss.logging.Logger;
import org.jboss.seam.rest.templating.ResponseTemplate;
import org.jboss.seam.rest.templating.TemplatingExtension;
import org.jboss.seam.rest.templating.TemplatingProvider;
import org.jboss.seam.servlet.event.Initialized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
@ApplicationScoped
public class TemplatingMessageBodyWriter
implements MessageBodyWriter<Object> {
    private static final Logger log = Logger.getLogger(TemplatingMessageBodyWriter.class);
    private TemplatingProvider provider;
    private Class<? extends TemplatingProvider> preferedTemplatingProvider;

    @Inject
    public void init(Instance<TemplatingProvider> providerInstance, TemplatingExtension extension) {
        log.debugv("Initializing {0}", (Object)this.getClass().getSimpleName());
        Instance instance = providerInstance;
        if (this.preferedTemplatingProvider != null) {
            log.debugv("Prefered templating provider specified. Selecting {0}", (Object)this.preferedTemplatingProvider.getName());
            instance = providerInstance.select(this.preferedTemplatingProvider, new Annotation[0]);
        }
        if (instance.isUnsatisfied()) {
            if (this.preferedTemplatingProvider == null) {
                log.info((Object)"No TemplateProvider found. Templating support disabled.");
                return;
            }
            throw new UnsatisfiedResolutionException("Unable to load prefered TemplateProvider " + this.preferedTemplatingProvider.getName());
        }
        if (instance.isAmbiguous()) {
            throw new AmbiguousResolutionException("Multiple TemplatingProviders found on classpath. Select the prefered one.");
        }
        this.provider = (TemplatingProvider)instance.get();
        log.infov("Seam REST Templating Extension enabled. Using {0}", (Object)this.provider.toString());
    }

    public void setServletContext(@Observes @Initialized ServletContext context) {
        if (this.provider != null) {
            log.debugv("Initializing templating provider.", new Object[0]);
            this.provider.init(context);
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (this.provider == null) {
            return false;
        }
        ResponseTemplate annotation = this.findAnnotation(annotations, mediaType);
        return annotation != null;
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ResponseTemplate annotation = this.findAnnotation(annotations, mediaType);
        this.provider.writeTo(t, annotation, annotations, mediaType, httpHeaders, entityStream);
    }

    private ResponseTemplate findAnnotation(Annotation[] annotations, MediaType type) {
        for (Annotation a : annotations) {
            ResponseTemplate annotation;
            MediaType producedType;
            if (ResponseTemplate.List.class.isAssignableFrom(a.annotationType())) {
                ResponseTemplate.List list = (ResponseTemplate.List)a;
                return this.findAnnotation(list.value(), type);
            }
            if (!ResponseTemplate.class.isAssignableFrom(a.annotationType()) || !(producedType = MediaType.valueOf((String)(annotation = (ResponseTemplate)a).produces())).isCompatible(type)) continue;
            return annotation;
        }
        return null;
    }

    public Class<? extends TemplatingProvider> getPreferedTemplatingProvider() {
        return this.preferedTemplatingProvider;
    }

    public void setPreferedTemplatingProvider(Class<? extends TemplatingProvider> preferedTemplatingProvider) {
        this.preferedTemplatingProvider = preferedTemplatingProvider;
    }
}

