/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.templating.freemarker;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.seam.rest.templating.ResponseTemplate;
import org.jboss.seam.rest.templating.TemplatingModel;
import org.jboss.seam.rest.templating.TemplatingProvider;
import org.jboss.seam.solder.el.Expressions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ApplicationScoped
public class FreeMarkerProvider
implements TemplatingProvider {
    private Configuration configuration;
    @Inject
    private TemplatingModel model;
    @Inject
    private Expressions expressions;

    @Override
    public void init(ServletContext servletContext) {
        this.configuration = new Configuration();
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.configuration.setServletContextForTemplateLoading((Object)servletContext, "/");
    }

    @Override
    public void writeTo(Object o, ResponseTemplate annotation, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream os) throws IOException {
        Template template = this.configuration.getTemplate(annotation.value());
        this.model.getData().put(annotation.responseName(), o);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(os);
            template.process((Object)new ModelWrapper(this.model.getData()), (Writer)writer);
            writer.flush();
        }
        catch (TemplateException e) {
            throw new RuntimeException("Unable to write FreeMarker response.", e);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ModelWrapper
    extends HashMap<String, Object> {
        private static final long serialVersionUID = -2967489085535480741L;

        public ModelWrapper(Map<String, Object> model) {
            super(model);
        }

        @Override
        public Object get(Object key) {
            if (this.containsKey(key)) {
                return super.get(key);
            }
            if (key instanceof String) {
                String elExpression = FreeMarkerProvider.this.expressions.toExpression((String)key);
                return FreeMarkerProvider.this.expressions.evaluateValueExpression(elExpression);
            }
            return null;
        }
    }
}

