/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.validation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import javax.validation.ConstraintViolation;
import javax.validation.Validator;
import javax.ws.rs.core.Context;
import org.jboss.logging.Logger;
import org.jboss.seam.rest.util.Annotations;
import org.jboss.seam.rest.util.Utils;
import org.jboss.seam.rest.validation.ValidateRequest;
import org.jboss.seam.rest.validation.ValidatedMethodMetadata;
import org.jboss.seam.rest.validation.ValidationException;
import org.jboss.seam.rest.validation.ValidationMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Interceptor
@ValidateRequest
public class ValidationInterceptor
implements Serializable {
    private static final long serialVersionUID = -5804986456381504613L;
    private static final ValidateRequest DEFAULT_INTERCEPTOR_BINDING = new ValidateRequest.ValidateLiteral();
    private static final Logger log = Logger.getLogger(ValidationInterceptor.class);
    @Inject
    private Validator validator;
    @Inject
    private ValidationMetadata metadata;

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        log.debugv("Validating {0}", (Object)ctx.getMethod().toGenericString());
        if (!this.metadata.containsMethodMetadata(ctx.getMethod())) {
            this.scanMethod(ctx.getMethod());
        }
        HashSet<ConstraintViolation<Object>> violations = new HashSet<ConstraintViolation<Object>>();
        ValidatedMethodMetadata method = this.metadata.getMethodMetadata(ctx.getMethod());
        ValidateRequest interceptorBinding = method.getInterceptorBinding();
        Class[] groups = interceptorBinding.groups();
        if (interceptorBinding.validateResourceFields()) {
            log.debugv("Validating JAX-RS resource {0}", ctx.getTarget());
            violations.addAll(this.validator.validate(ctx.getTarget(), groups));
        }
        if (interceptorBinding.validateMessageBody() && method.getMessageBody() != null) {
            Object parameter = ctx.getParameters()[method.getMessageBody()];
            log.debugv("Validating HTTP message body {0}", parameter);
            violations.addAll(this.validator.validate(parameter, groups));
        }
        if (interceptorBinding.validateParameterObjects()) {
            for (Integer parameterIndex : method.getParameterObjects()) {
                Object parameter = ctx.getParameters()[parameterIndex];
                log.debugv("Validating parameter object {0}", parameter);
                violations.addAll(this.validator.validate(parameter, groups));
            }
        }
        if (violations.isEmpty()) {
            log.debug((Object)"Validation completed. No violations found.");
            return ctx.proceed();
        }
        log.debugv("Validation completed. {0} violations found.", (Object)violations.size());
        throw new ValidationException(violations);
    }

    private void scanMethod(Method method) {
        Integer messageBodyIndex = null;
        HashSet<Integer> parameterObjects = new HashSet<Integer>();
        ValidateRequest interceptorBinding = this.getInterceptorBinding(method);
        log.debugv("This is the first time {0} is invoked. Scanning.", (Object)method);
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        for (int i = 0; i < parameterAnnotations.length; ++i) {
            if (parameterAnnotations[i].length == 0) {
                log.debugv("{0} identified as the message body.", method.getParameterTypes()[i]);
                messageBodyIndex = i;
                continue;
            }
            if (!this.isParameterObject(method.getParameterTypes()[i], method.getParameterAnnotations()[i])) continue;
            log.debugv("{0} identified as the parameter object.", method.getParameterTypes()[i]);
            parameterObjects.add(i);
        }
        this.metadata.addMethodMetadata(new ValidatedMethodMetadata(method, messageBodyIndex, parameterObjects, interceptorBinding));
    }

    private ValidateRequest getInterceptorBinding(Method method) {
        ValidateRequest interceptorBinding = Annotations.getAnnotation(method, ValidateRequest.class);
        if (interceptorBinding == null) {
            log.debugv("Unable to find @ValidateRequest interceptor binding for {0}", (Object)method.toGenericString());
            return DEFAULT_INTERCEPTOR_BINDING;
        }
        return interceptorBinding;
    }

    private boolean isParameterObject(Class<?> parameterType, Annotation[] annotations) {
        if (annotations.length == 0) {
            return false;
        }
        if (parameterType.isPrimitive() || Utils.isPrimitiveWrapper(parameterType) || String.class.isAssignableFrom(parameterType)) {
            return false;
        }
        for (Annotation annotation : annotations) {
            if (!(annotation instanceof Context)) continue;
            return false;
        }
        return true;
    }
}

