/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.client;

import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessBean;
import javax.enterprise.inject.spi.ProcessManagedBean;
import org.jboss.logging.Logger;
import org.jboss.seam.rest.client.RestClient;
import org.jboss.seam.rest.client.RestClientProducer;
import org.jboss.seam.rest.client.RestClientProducerBean;
import org.jboss.seam.rest.util.Annotations;
import org.jboss.seam.rest.util.Utils;

public class RestClientExtension
implements Extension {
    private static final Logger log = Logger.getLogger(RestClientExtension.class);
    private static final String RESTEASY_PROVIDER_FACTORY_NAME = "org.jboss.resteasy.spi.ResteasyProviderFactory";
    private boolean enabled;
    private Set<Type> jaxrsInterfaces = new HashSet<Type>();
    private Bean<RestClientProducer> restClientProducerBean;

    public void registerExtension(@Observes BeforeBeanDiscovery event, BeanManager manager) {
        this.enabled = Utils.isClassAvailable(RESTEASY_PROVIDER_FACTORY_NAME);
    }

    public void getRestClientProducerDelegate(@Observes ProcessManagedBean<RestClientProducer> event) {
        this.restClientProducerBean = event.getBean();
    }

    public <T> void scanInjectionPointsForJaxrsInterfaces(@Observes ProcessBean<T> event) {
        if (!this.enabled) {
            return;
        }
        for (InjectionPoint ip : event.getBean().getInjectionPoints()) {
            Class clazz;
            RestClient qualifier = Annotations.getAnnotation(ip.getQualifiers(), RestClient.class);
            if (qualifier == null || !(ip.getType() instanceof Class) || !(clazz = (Class)ip.getType()).isInterface()) continue;
            this.jaxrsInterfaces.add(clazz);
        }
    }

    public void afterBeanDiscovery(@Observes AfterBeanDiscovery event, BeanManager manager) {
        if (this.enabled && !this.jaxrsInterfaces.isEmpty()) {
            if (this.restClientProducerBean == null) {
                log.warn((Object)"ProcessProducerMethod<RestClientProducer, Object> not fired. Client extension may not work properly.");
                return;
            }
            event.addBean((Bean)new RestClientProducerBean(this.restClientProducerBean, this.jaxrsInterfaces, manager));
        }
    }

    public boolean isClientIntegrationEnabled() {
        return this.enabled;
    }
}

