/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.client;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.seam.rest.client.RestClient;
import org.jboss.seam.rest.util.Annotations;
import org.jboss.seam.rest.util.Interpolator;

@ApplicationScoped
public class RestClientProducer {
    @Inject
    private Interpolator interpolator;

    public Object produceRestClient(InjectionPoint ip, ClientExecutor executor) {
        RestClient qualifier = Annotations.getAnnotation(ip.getQualifiers(), RestClient.class);
        if (qualifier == null || !(ip.getType() instanceof Class)) {
            throw new IllegalStateException("@RestClient injection point " + ip.getMember() + " is not valid.");
        }
        Class clazz = (Class)ip.getType();
        String url = this.interpolator.interpolate(qualifier.value());
        return ProxyFactory.create((Class)clazz, (String)url, (ClientExecutor)executor);
    }

    @Produces
    @RestClient(value="")
    public ClientRequest produceClientRequest(InjectionPoint ip, ClientExecutor executor) {
        RestClient qualifier = Annotations.getAnnotation(ip.getQualifiers(), RestClient.class);
        if (qualifier == null) {
            throw new IllegalStateException("@RestClient injection point " + ip.getMember() + " is not valid.");
        }
        String url = this.interpolator.interpolate(qualifier.value());
        return new ClientRequest(url, executor);
    }
}

