/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;

public class Annotations {
    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationClass) {
        if (clazz.isAnnotationPresent(annotationClass)) {
            return clazz.getAnnotation(annotationClass);
        }
        for (Annotation annotation : clazz.getAnnotations()) {
            if (!annotation.annotationType().isAnnotationPresent(annotationClass)) continue;
            return annotation.annotationType().getAnnotation(annotationClass);
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotationClass) {
        if (method.isAnnotationPresent(annotationClass)) {
            return method.getAnnotation(annotationClass);
        }
        return Annotations.getAnnotation(method.getDeclaringClass(), annotationClass);
    }

    public static <T extends Annotation> T getAnnotation(Collection<? extends Annotation> annotations, Class<T> annotationClass) {
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().equals(annotationClass)) {
                return (T)annotation;
            }
            for (Annotation innerAnnotation : annotation.annotationType().getAnnotations()) {
                if (!innerAnnotation.annotationType().equals(annotationClass)) continue;
                return (T)innerAnnotation;
            }
        }
        return null;
    }

    public static <T extends Annotation> T getAnnotation(Annotation[] annotations, Class<T> annotationClass) {
        return Annotations.getAnnotation(Arrays.asList(annotations), annotationClass);
    }
}

