/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest;

import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.jboss.logging.Logger;
import org.jboss.seam.rest.client.RestClientExtension;
import org.jboss.seam.rest.exceptions.ExceptionMappingExtension;
import org.jboss.seam.rest.exceptions.RestResource;
import org.jboss.seam.rest.exceptions.SeamExceptionMapper;
import org.jboss.seam.rest.templating.TemplatingMessageBodyWriter;

@WebListener
public class SeamRestStartup
implements ServletContextListener {
    private static final Logger log = Logger.getLogger(SeamRestStartup.class);
    @Inject
    private RestClientExtension restClientExtension;
    @Inject
    private ExceptionMappingExtension exceptionMappingExtension;
    @Inject
    private SeamExceptionMapper exceptionMapper;
    @Inject
    private TemplatingMessageBodyWriter templating;
    @Inject
    @RestResource
    private Event<ServletContext> event;

    public void contextInitialized(ServletContextEvent sce) {
        this.event.fire((Object)sce.getServletContext());
        log.infov("Seam REST {0} (Client integration: {1}, Catch integration: {2}, {3} exception mapping rules, Templating provider: {4})", new Object[]{this.getClass().getPackage().getSpecificationVersion(), this.restClientExtension.isClientIntegrationEnabled() ? "enabled" : "disabled", this.exceptionMappingExtension.isCatchIntegrationEnabled() ? "enabled" : "disabled", this.exceptionMapper.getMappings().size(), this.templating.getProvider() == null ? "null" : this.templating.getProvider().toString()});
    }

    public void contextDestroyed(ServletContextEvent sce) {
    }
}

