/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.client;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jboss.logging.Logger;
import org.jboss.resteasy.client.ClientExecutor;
import org.jboss.resteasy.client.ClientRequest;
import org.jboss.resteasy.client.ProxyFactory;
import org.jboss.resteasy.client.core.ClientErrorInterceptor;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.seam.rest.client.RestClient;
import org.jboss.seam.rest.util.Interpolator;
import org.jboss.seam.solder.reflection.AnnotationInspector;

@ApplicationScoped
public class RestClientProducer {
    private static final Logger log = Logger.getLogger(RestClientProducer.class);
    @Inject
    private Interpolator interpolator;
    @Inject
    private BeanManager manager;

    @Inject
    public void initClientSupport(Instance<ClientErrorInterceptor> interceptors) {
        for (ClientErrorInterceptor interceptor : interceptors) {
            ResteasyProviderFactory.getInstance().addClientErrorInterceptor(interceptor);
            log.infov("Registered ClientErrorInterceptor {0}", interceptor.getClass());
        }
    }

    public Object produceRestClient(InjectionPoint ip, ClientExecutor executor) {
        RestClient qualifier = (RestClient)AnnotationInspector.getAnnotation((Annotated)ip.getAnnotated(), RestClient.class, (BeanManager)this.manager);
        if (qualifier == null || !(ip.getType() instanceof Class)) {
            throw new IllegalStateException("@RestClient injection point " + ip.getMember() + " is not valid.");
        }
        Class clazz = (Class)ip.getType();
        String url = this.interpolator.interpolate(qualifier.value());
        return ProxyFactory.create((Class)clazz, (String)url, (ClientExecutor)executor);
    }

    @Produces
    @RestClient(value="")
    public ClientRequest produceClientRequest(InjectionPoint ip, ClientExecutor executor) {
        RestClient qualifier = (RestClient)AnnotationInspector.getAnnotation((Annotated)ip.getAnnotated(), RestClient.class, (BeanManager)this.manager);
        if (qualifier == null) {
            throw new IllegalStateException("@RestClient injection point " + ip.getMember() + " is not valid.");
        }
        String url = this.interpolator.interpolate(qualifier.value());
        return new ClientRequest(url, executor);
    }
}

