/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.templating;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.UnsatisfiedResolutionException;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.jboss.logging.Logger;
import org.jboss.seam.rest.SeamRestConfiguration;
import org.jboss.seam.rest.exceptions.RestResource;
import org.jboss.seam.rest.templating.ResponseTemplate;
import org.jboss.seam.rest.templating.TemplatingProvider;

@Provider
@ApplicationScoped
public class TemplatingMessageBodyWriter
implements MessageBodyWriter<Object> {
    private static final Logger log = Logger.getLogger(TemplatingMessageBodyWriter.class);
    private TemplatingProvider provider;

    @Inject
    public void init(Instance<TemplatingProvider> providerInstance, Instance<SeamRestConfiguration> configuration) {
        log.debugv("Initializing {0}", (Object)this.getClass().getSimpleName());
        Instance instance = providerInstance;
        Class<? extends TemplatingProvider> preferedTemplatingProvider = null;
        if (!configuration.isAmbiguous() && !configuration.isUnsatisfied()) {
            preferedTemplatingProvider = ((SeamRestConfiguration)configuration.get()).getPreferedTemplatingProvider();
        }
        if (preferedTemplatingProvider != null) {
            log.debugv("Prefered templating provider specified. Selecting {0}", (Object)preferedTemplatingProvider.getName());
            instance = providerInstance.select(preferedTemplatingProvider, new Annotation[0]);
        }
        if (instance.isUnsatisfied()) {
            if (preferedTemplatingProvider == null) {
                log.debug((Object)"No TemplateProvider found. Templating support disabled.");
                return;
            }
            throw new UnsatisfiedResolutionException("Unable to load prefered TemplateProvider " + preferedTemplatingProvider.getName());
        }
        if (instance.isAmbiguous()) {
            throw new AmbiguousResolutionException("Multiple TemplatingProviders found on classpath. Select the prefered one.");
        }
        this.provider = (TemplatingProvider)instance.get();
    }

    public void init(@Observes @RestResource ServletContext context) {
        if (this.provider != null) {
            log.debugv("Initializing templating provider.", new Object[0]);
            this.provider.init(context);
        }
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        if (this.provider == null) {
            return false;
        }
        ResponseTemplate annotation = this.findAnnotation(annotations, mediaType);
        return annotation != null;
    }

    public long getSize(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ResponseTemplate annotation = this.findAnnotation(annotations, mediaType);
        this.provider.writeTo(t, annotation, annotations, mediaType, httpHeaders, entityStream);
    }

    private ResponseTemplate findAnnotation(Annotation[] annotations, MediaType type) {
        for (Annotation a : annotations) {
            ResponseTemplate annotation;
            MediaType producedType;
            if (ResponseTemplate.List.class.isAssignableFrom(a.annotationType())) {
                ResponseTemplate.List list = (ResponseTemplate.List)a;
                return this.findAnnotation(list.value(), type);
            }
            if (!ResponseTemplate.class.isAssignableFrom(a.annotationType()) || !(producedType = MediaType.valueOf((String)(annotation = (ResponseTemplate)a).produces())).isCompatible(type)) continue;
            return annotation;
        }
        return null;
    }

    public TemplatingProvider getProvider() {
        return this.provider;
    }
}

