/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.rest.templating.freemarker;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.annotation.Annotation;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.seam.rest.templating.ModelWrapper;
import org.jboss.seam.rest.templating.ResponseTemplate;
import org.jboss.seam.rest.templating.TemplatingModel;
import org.jboss.seam.rest.templating.TemplatingProvider;

@ApplicationScoped
public class FreeMarkerProvider
implements TemplatingProvider {
    private Configuration configuration;
    @Inject
    private TemplatingModel model;
    @Inject
    private BeanManager manager;

    @Override
    public void init(ServletContext servletContext) {
        this.configuration = new Configuration();
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        this.configuration.setServletContextForTemplateLoading((Object)servletContext, "/");
    }

    @Override
    public void writeTo(Object o, ResponseTemplate annotation, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream os) throws IOException {
        Template template = this.configuration.getTemplate(annotation.value());
        this.model.getData().put(annotation.responseName(), o);
        try {
            OutputStreamWriter writer = new OutputStreamWriter(os);
            template.process((Object)new ModelWrapper(this.model.getData(), this.manager), (Writer)writer);
            writer.flush();
        }
        catch (TemplateException e) {
            throw new RuntimeException("Unable to write FreeMarker response.", e);
        }
    }

    public String toString() {
        return this.getClass().getName();
    }
}

