/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.examples.openid;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.inject.Model;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.security.examples.openid.AttributeVO;
import org.jboss.seam.security.external.dialogues.api.DialogueScoped;
import org.jboss.seam.security.external.openid.api.OpenIdProviderApi;
import org.jboss.seam.security.external.openid.api.OpenIdRequestedAttribute;

@Model
@DialogueScoped
public class Attributes
implements Serializable {
    private static final long serialVersionUID = -6945192710223411921L;
    private List<AttributeVO> attributeVOs;
    @Inject
    private OpenIdProviderApi providerApi;

    public void setRequestedAttributes(List<OpenIdRequestedAttribute> requestedAttributes) {
        this.attributeVOs = new LinkedList();
        for (OpenIdRequestedAttribute requestedAttribute : requestedAttributes) {
            AttributeVO attributeVO = new AttributeVO();
            attributeVO.setRequestedAttribute(requestedAttribute);
            this.attributeVOs.add(attributeVO);
        }
    }

    public List<AttributeVO> getAttributeVOs() {
        return this.attributeVOs;
    }

    public void confirm() {
        HashMap<String, List<String>> attributeValues = new HashMap<String, List<String>>();
        for (AttributeVO attributeVO : this.attributeVOs) {
            if (attributeVO.getAttributeValue() == null) continue;
            attributeValues.put(attributeVO.getRequestedAttribute().getAlias(), Arrays.asList(attributeVO.getAttributeValue()));
        }
        this.providerApi.setAttributes(attributeValues, (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse());
    }
}

