/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.examples.openid;

import java.io.Serializable;
import javax.enterprise.context.SessionScoped;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.security.external.openid.api.OpenIdProviderApi;

@SessionScoped
@Named
public class Identity
implements Serializable {
    private static final long serialVersionUID = -7096110154986991513L;
    private String userName;
    @Inject
    private OpenIdProviderApi providerApi;

    public void localLogin(String userName) {
        this.userName = userName;
    }

    public void logout() {
        if (this.isLoggedIn()) {
            this.userName = null;
            this.redirectToViewId("/Index.xhtml");
        } else {
            FacesMessage facesMessage = new FacesMessage("Not logged in.");
            FacesContext.getCurrentInstance().addMessage(null, facesMessage);
        }
    }

    public boolean isLoggedIn() {
        return this.userName != null;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getOpLocalIdentifier() {
        return this.providerApi.getOpLocalIdentifierForUserName(this.userName);
    }

    public void redirectToLoginIfNotLoggedIn() {
        if (!this.isLoggedIn()) {
            this.redirectToViewId("/Login.xhtml");
        }
    }

    private void redirectToViewId(String viewId) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        FacesContext.getCurrentInstance().getApplication().getNavigationHandler().handleNavigation(facesContext, null, viewId + "?faces-redirect=true");
    }
}

