/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.examples.openid;

import javax.enterprise.inject.Model;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.security.examples.openid.Identity;
import org.jboss.seam.security.external.dialogues.api.DialogueManager;
import org.jboss.seam.security.external.openid.api.OpenIdProviderApi;

@Model
public class Login {
    @Inject
    private OpenIdProviderApi opApi;
    private String userNameReceivedFromRp;
    private String realm;
    private String userName;
    @Inject
    private DialogueManager dialogueManager;
    @Inject
    private Identity identity;

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getUserNameReceivedFromRp() {
        return this.userNameReceivedFromRp;
    }

    public void setUserNameReceivedFromRp(String userNameReceivedFromRp) {
        this.userNameReceivedFromRp = userNameReceivedFromRp;
    }

    public String getRealm() {
        return this.realm;
    }

    public void setRealm(String realm) {
        this.realm = realm;
    }

    public boolean isDialogueActive() {
        return this.dialogueManager.isAttached();
    }

    public String login() {
        String userName = this.userNameReceivedFromRp != null ? this.userNameReceivedFromRp : this.userName;
        this.identity.localLogin(userName);
        if (this.dialogueManager.isAttached()) {
            this.opApi.authenticationSucceeded(userName, (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse());
            return null;
        }
        return "LOCAL_LOGIN";
    }

    public void cancel() {
        if (!this.dialogueManager.isAttached()) {
            throw new IllegalStateException("cancel method can only be called during an OpenID login");
        }
        this.opApi.authenticationFailed((HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse());
    }
}

