/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.examples.id_consumer;

import java.io.IOException;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.jboss.seam.security.events.DeferredAuthenticationEvent;
import org.jboss.seam.security.external.api.ResponseHolder;
import org.jboss.seam.security.external.openid.OpenIdAuthenticator;
import org.jboss.seam.security.external.openid.api.OpenIdPrincipal;
import org.jboss.seam.security.external.spi.OpenIdRelyingPartySpi;

public class OpenIdRelyingPartySpiImpl
implements OpenIdRelyingPartySpi {
    @Inject
    private ServletContext servletContext;
    @Inject
    OpenIdAuthenticator openIdAuthenticator;
    @Inject
    Event<DeferredAuthenticationEvent> deferredAuthentication;

    public void loginSucceeded(OpenIdPrincipal principal, ResponseHolder responseHolder) {
        try {
            this.openIdAuthenticator.success(principal);
            this.deferredAuthentication.fire((Object)new DeferredAuthenticationEvent());
            responseHolder.getResponse().sendRedirect(this.servletContext.getContextPath() + "/UserInfo.jsf");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void loginFailed(String message, ResponseHolder responseHolder) {
        try {
            responseHolder.getResponse().sendRedirect(this.servletContext.getContextPath() + "/AuthenticationFailed.jsf");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

