/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.examples.id_consumer;

import java.util.Properties;
import org.jboss.solder.core.Veto;

@Veto
public class PropertyReader {
    private Properties properties;

    public PropertyReader(Properties properties) {
        this.properties = properties;
    }

    public String getString(String name, String defaultValue) {
        if (this.properties != null) {
            return this.properties.getProperty(name, defaultValue);
        }
        return defaultValue;
    }

    public int getInt(String name, int defaultValue) {
        if (this.properties != null && this.properties.containsKey(name)) {
            return Integer.parseInt(this.properties.getProperty(name));
        }
        return defaultValue;
    }

    public boolean getBoolean(String name, boolean defaultValue) {
        if (this.properties != null && this.properties.containsKey(name)) {
            return Boolean.parseBoolean(this.properties.getProperty(name));
        }
        return defaultValue;
    }

    public String[] getStringArray(String name, String[] defaultValue) {
        if (this.properties != null && this.properties.containsKey(name)) {
            return this.properties.getProperty(name).split(";");
        }
        return defaultValue;
    }
}

