/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.openid;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletResponse;
import org.jboss.logging.Logger;
import org.jboss.seam.security.Authenticator;
import org.jboss.seam.security.BaseAuthenticator;
import org.jboss.seam.security.external.openid.OpenIdUser;
import org.jboss.seam.security.external.openid.api.OpenIdPrincipal;
import org.jboss.seam.security.external.openid.api.OpenIdRelyingPartyApi;
import org.jboss.seam.security.external.openid.api.OpenIdRequestedAttribute;
import org.jboss.seam.security.external.openid.providers.OpenIdProvider;

@Named(value="openIdAuthenticator")
@SessionScoped
public class OpenIdAuthenticator
extends BaseAuthenticator
implements Authenticator,
Serializable {
    private static final long serialVersionUID = 4669651866032932651L;
    private String openIdProviderUrl;
    @Inject
    private OpenIdRelyingPartyApi openIdApi;
    @Inject
    List<OpenIdProvider> providers;
    @Inject
    Logger log;
    private String providerCode;

    public String getProviderCode() {
        return this.providerCode;
    }

    public void setProviderCode(String providerCode) {
        this.providerCode = providerCode;
    }

    public String getOpenIdProviderUrl() {
        return this.openIdProviderUrl;
    }

    public void setOpenIdProviderUrl(String openIdProviderUrl) {
        this.openIdProviderUrl = openIdProviderUrl;
    }

    protected OpenIdProvider getSelectedProvider() {
        if (this.providerCode != null) {
            for (OpenIdProvider provider : this.providers) {
                if (!this.providerCode.equals(provider.getCode())) continue;
                return provider;
            }
        }
        return null;
    }

    public void authenticate() {
        String url;
        LinkedList<OpenIdRequestedAttribute> attributes = new LinkedList<OpenIdRequestedAttribute>();
        attributes.add(this.openIdApi.createOpenIdRequestedAttribute("email", "http://schema.openid.net/contact/email", true, 1));
        OpenIdProvider selectedProvider = this.getSelectedProvider();
        String string = url = selectedProvider != null ? selectedProvider.getUrl() : this.getOpenIdProviderUrl();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Logging in using OpenID url: " + url));
        }
        this.openIdApi.login(url, attributes, (HttpServletResponse)FacesContext.getCurrentInstance().getExternalContext().getResponse());
        this.setStatus(Authenticator.AuthenticationStatus.DEFERRED);
    }

    public List<OpenIdProvider> getProviders() {
        return this.providers;
    }

    public void success(OpenIdPrincipal principal) {
        this.setUser(new OpenIdUser(principal));
        this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
    }
}

