/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.virtualapplications;

import java.lang.annotation.Annotation;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.servlet.ServletContext;
import org.jboss.seam.security.contexts.ContextualInstance;
import org.jboss.seam.security.contexts.HashMapBeanStore;
import org.jboss.seam.security.external.virtualapplications.api.VirtualApplicationScoped;

public class VirtualApplicationContext
implements Context {
    private static final String BEAN_STORE_ATTRIBUTE_NAME_PREFIX = "virtualApplicationContextBeanStore";
    private ServletContext servletContext;
    private final ThreadLocal<String> hostNameThreadLocal = new ThreadLocal();

    protected HashMapBeanStore getBeanStore() {
        return this.getBeanStore(this.hostNameThreadLocal.get());
    }

    private HashMapBeanStore getBeanStore(String hostName) {
        HashMapBeanStore beanStore = (HashMapBeanStore)this.servletContext.getAttribute(this.getAttributeName(hostName));
        return beanStore;
    }

    private void createBeanStore(String hostName) {
        HashMapBeanStore beanStore = new HashMapBeanStore();
        this.servletContext.setAttribute(this.getAttributeName(hostName), (Object)beanStore);
    }

    private void removeBeanStore(String hostName) {
        this.servletContext.removeAttribute(this.getAttributeName(hostName));
    }

    private String getAttributeName(String hostName) {
        return "virtualApplicationContextBeanStore_" + hostName;
    }

    public void initialize(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void destroy() {
        this.servletContext = null;
    }

    public void create(String hostName) {
        this.createBeanStore(hostName);
        this.attach(hostName);
    }

    public void remove() {
        this.getBeanStore().clear();
        this.removeBeanStore(this.hostNameThreadLocal.get());
        this.detach();
    }

    public boolean isExistingVirtualApplication(String hostName) {
        return this.servletContext != null && this.getBeanStore(hostName) != null;
    }

    public void attach(String hostName) {
        this.hostNameThreadLocal.set(hostName);
    }

    public void detach() {
        this.hostNameThreadLocal.set(null);
    }

    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (!this.isActive()) {
            throw new ContextNotActiveException();
        }
        ContextualInstance beanInstance = this.getBeanStore().get(contextual);
        if (beanInstance != null) {
            return (T)beanInstance.getInstance();
        }
        if (creationalContext != null) {
            Object instance = contextual.create(creationalContext);
            if (instance != null) {
                beanInstance = new ContextualInstance(contextual, creationalContext, instance);
                this.getBeanStore().put(contextual, beanInstance);
            }
            return (T)instance;
        }
        return null;
    }

    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    public Class<? extends Annotation> getScope() {
        return VirtualApplicationScoped.class;
    }

    public boolean isActive() {
        return this.hostNameThreadLocal.get() != null;
    }
}

