/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.virtualapplications;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import org.jboss.seam.security.external.virtualapplications.AfterVirtualApplicationManagerCreationEvent;
import org.jboss.seam.security.external.virtualapplications.VirtualApplicationBean;
import org.jboss.seam.security.external.virtualapplications.VirtualApplicationContext;
import org.jboss.seam.security.external.virtualapplications.VirtualApplicationContextExtension;
import org.jboss.seam.security.external.virtualapplications.api.AfterVirtualApplicationCreation;
import org.jboss.seam.servlet.event.Destroyed;
import org.jboss.seam.servlet.event.Initialized;

@ApplicationScoped
public class VirtualApplicationManager {
    @Inject
    private VirtualApplicationContextExtension virtualApplicationContextExtension;
    @Inject
    private Instance<VirtualApplicationBean> virtualApplication;
    @Inject
    private BeanManager beanManager;
    private Set<String> hostNames = new HashSet<String>();

    protected void servletInitialized(@Observes @Initialized ServletContext context) {
        this.getVirtualApplicationContext().initialize(context);
        AfterVirtualApplicationManagerCreationEvent afterVirtualApplicationManagerCreation = new AfterVirtualApplicationManagerCreationEvent();
        this.beanManager.fireEvent((Object)afterVirtualApplicationManagerCreation, new Annotation[0]);
        for (String hostName : afterVirtualApplicationManagerCreation.getHostNames()) {
            this.hostNames.add(hostName);
            this.getVirtualApplicationContext().create(hostName);
            ((VirtualApplicationBean)this.virtualApplication.get()).setHostName(hostName);
            this.beanManager.fireEvent((Object)new AfterVirtualApplicationCreation(), new Annotation[0]);
            this.getVirtualApplicationContext().detach();
        }
    }

    protected void servletDestroyed(@Observes @Destroyed ServletContext context) {
        for (String hostName : this.hostNames) {
            if (!this.getVirtualApplicationContext().isExistingVirtualApplication(hostName)) continue;
            this.attach(hostName);
            this.getVirtualApplicationContext().destroy();
        }
    }

    protected void requestInitialized(@Observes @Initialized ServletRequest request) {
        String hostName = request.getServerName();
        if (this.getVirtualApplicationContext().isExistingVirtualApplication(hostName)) {
            this.attach(hostName);
        }
    }

    protected void requestDestroyed(@Observes @Destroyed ServletRequest request) {
        if (this.getVirtualApplicationContext().isActive()) {
            this.detach();
        }
    }

    public void attach(String hostName) {
        this.getVirtualApplicationContext().attach(hostName);
        ((VirtualApplicationBean)this.virtualApplication.get()).setHostName(hostName);
    }

    public void detach() {
        this.getVirtualApplicationContext().detach();
    }

    public Set<String> getHostNames() {
        return this.hostNames;
    }

    private VirtualApplicationContext getVirtualApplicationContext() {
        return this.virtualApplicationContextExtension.getVirtualApplicationContext();
    }
}

