/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.dialogues;

import java.io.IOException;
import java.net.URLDecoder;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.security.external.dialogues.api.DialogueManager;

@WebFilter(filterName="DialogueFilter", urlPatterns={"/openid/*"})
public class DialogueFilter
implements Filter {
    public static final String DIALOGUE_ID_PARAM = "dialogueId";
    @Inject
    private DialogueManager manager;

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpServletRequest;
        String queryString;
        if (this.manager.isAttached()) {
            this.manager.detachDialogue();
        }
        if ((queryString = (httpServletRequest = (HttpServletRequest)request).getQueryString()) != null) {
            for (String param : queryString.split("&")) {
                if (!param.startsWith(DIALOGUE_ID_PARAM) || param.length() <= DIALOGUE_ID_PARAM.length() + 1) continue;
                String dialogueId = URLDecoder.decode(param.substring(DIALOGUE_ID_PARAM.length() + 1), "utf-8");
                if (dialogueId == null) break;
                if (!this.manager.isExistingDialogue(dialogueId)) {
                    ((HttpServletResponse)response).sendError(400, "dialogue " + dialogueId + " does not exist");
                    return;
                }
                this.manager.attachDialogue(dialogueId);
                break;
            }
        }
        chain.doFilter(request, response);
        if (this.manager.isAttached()) {
            this.manager.detachDialogue();
        }
    }

    public void destroy() {
    }
}

