/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.openid;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.security.Authenticator;
import org.jboss.seam.security.BaseAuthenticator;
import org.jboss.seam.security.external.openid.OpenIdUser;
import org.jboss.seam.security.external.openid.api.OpenIdPrincipal;
import org.jboss.seam.security.external.openid.api.OpenIdRelyingPartyApi;
import org.jboss.seam.security.external.openid.api.OpenIdRequestedAttribute;
import org.jboss.seam.security.external.openid.providers.OpenIdProvider;
import org.jboss.seam.solder.logging.Logger;

@Named(value="openIdAuthenticator")
@SessionScoped
public class OpenIdAuthenticator
extends BaseAuthenticator
implements Authenticator,
Serializable {
    private static final long serialVersionUID = 4669651866032932651L;
    @Inject
    Instance<OpenIdRelyingPartyApi> openIdApiInstance;
    @Inject
    List<OpenIdProvider> providers;
    @Inject
    Logger log;
    @Inject
    HttpServletResponse response;
    private String providerCode;

    public String getProviderCode() {
        return this.providerCode;
    }

    public void setProviderCode(String providerCode) {
        this.providerCode = providerCode;
    }

    protected OpenIdProvider getSelectedProvider() {
        if (this.providerCode != null) {
            for (OpenIdProvider provider : this.providers) {
                if (!this.providerCode.equals(provider.getCode())) continue;
                return provider;
            }
        }
        return null;
    }

    public void authenticate() {
        OpenIdProvider selectedProvider = this.getSelectedProvider();
        if (selectedProvider == null) {
            throw new IllegalStateException("No OpenID provider has been selected");
        }
        OpenIdRelyingPartyApi openIdApi = (OpenIdRelyingPartyApi)this.openIdApiInstance.get();
        LinkedList<OpenIdRequestedAttribute> attributes = new LinkedList<OpenIdRequestedAttribute>();
        selectedProvider.requestAttributes(openIdApi, attributes);
        openIdApi.login(selectedProvider.getUrl(), attributes, this.getResponse());
        this.setStatus(Authenticator.AuthenticationStatus.DEFERRED);
    }

    protected HttpServletResponse getResponse() {
        return this.response;
    }

    public List<OpenIdProvider> getProviders() {
        return this.providers;
    }

    public void success(OpenIdPrincipal principal) {
        this.setUser(new OpenIdUser(principal));
        this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
    }
}

