/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml;

import java.io.StringWriter;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.jboss.seam.security.external.jaxb.samlv2.assertion.AssertionType;
import org.jboss.seam.security.external.jaxb.samlv2.assertion.ConditionsType;
import org.w3c.dom.Document;

public class SamlUtils {
    public static XMLGregorianCalendar getXMLGregorianCalendarNow() {
        return SamlUtils.getXMLGregorianCalendar(new GregorianCalendar());
    }

    public static XMLGregorianCalendar getXMLGregorianCalendarNowPlusDuration(int field, int amount) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.add(field, amount);
        return SamlUtils.getXMLGregorianCalendar(gregorianCalendar);
    }

    private static XMLGregorianCalendar getXMLGregorianCalendar(GregorianCalendar gregorianCalendar) {
        try {
            DatatypeFactory dtf = DatatypeFactory.newInstance();
            return dtf.newXMLGregorianCalendar(gregorianCalendar);
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean hasAssertionExpired(AssertionType assertion) {
        ConditionsType conditionsType = assertion.getConditions();
        if (conditionsType != null) {
            int val;
            XMLGregorianCalendar now = SamlUtils.getXMLGregorianCalendarNow();
            XMLGregorianCalendar notBefore = conditionsType.getNotBefore();
            XMLGregorianCalendar notOnOrAfter = conditionsType.getNotOnOrAfter();
            if (notBefore != null && ((val = notBefore.compare(now)) == 2 || val == 1)) {
                return true;
            }
            return notOnOrAfter != null && (val = notOnOrAfter.compare(now)) != 1;
        }
        return false;
    }

    public static String getDocumentAsString(Document document) {
        DOMSource source = new DOMSource(document);
        StringWriter sw = new StringWriter();
        StreamResult streamResult = new StreamResult(sw);
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.setOutputProperty("indent", "no");
            transformer.transform(source, streamResult);
        }
        catch (TransformerException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }
}

