/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml.idp;

import java.io.Reader;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.jboss.seam.security.external.SamlNameIdImpl;
import org.jboss.seam.security.external.SamlPrincipalImpl;
import org.jboss.seam.security.external.dialogues.api.Dialogued;
import org.jboss.seam.security.external.jaxb.samlv2.assertion.AttributeType;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.EntityDescriptorType;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.IDPSSODescriptorType;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.IndexedEndpointType;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.ObjectFactory;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.SPSSODescriptorType;
import org.jboss.seam.security.external.saml.SamlDialogue;
import org.jboss.seam.security.external.saml.SamlEntityBean;
import org.jboss.seam.security.external.saml.SamlExternalEntity;
import org.jboss.seam.security.external.saml.SamlIdpOrSp;
import org.jboss.seam.security.external.saml.SamlServiceType;
import org.jboss.seam.security.external.saml.api.SamlIdpSession;
import org.jboss.seam.security.external.saml.api.SamlNameId;
import org.jboss.seam.security.external.saml.api.SamlPrincipal;
import org.jboss.seam.security.external.saml.idp.SamlExternalServiceProvider;
import org.jboss.seam.security.external.saml.idp.SamlIdpBeanApi;
import org.jboss.seam.security.external.saml.idp.SamlIdpSessionImpl;
import org.jboss.seam.security.external.saml.idp.SamlIdpSessions;
import org.jboss.seam.security.external.saml.idp.SamlIdpSingleLogoutService;
import org.jboss.seam.security.external.saml.idp.SamlIdpSingleSignOnService;

@Typed(value={SamlIdpBean.class})
public class SamlIdpBean
extends SamlEntityBean
implements SamlIdpBeanApi {
    @Inject
    private SamlIdpSingleSignOnService samlIdpSingleSignOnService;
    @Inject
    private SamlIdpSingleLogoutService samlIdpSingleSignLogoutService;
    @Inject
    private SamlIdpSessions samlIdpSessions;
    private List<SamlExternalServiceProvider> serviceProviders = new LinkedList<SamlExternalServiceProvider>();
    private boolean wantAuthnRequestsSigned = false;
    @Inject
    private Instance<SamlDialogue> samlDialogue;

    @Override
    public List<SamlExternalServiceProvider> getServiceProviders() {
        return this.serviceProviders;
    }

    public SamlExternalServiceProvider addExternalServiceProvider(String entityId, SPSSODescriptorType spSsoDescriptor) {
        SamlExternalServiceProvider samlServiceProvider = new SamlExternalServiceProvider(entityId, spSsoDescriptor);
        this.serviceProviders.add(samlServiceProvider);
        return samlServiceProvider;
    }

    @Override
    public SamlExternalServiceProvider addExternalSamlEntity(Reader reader) {
        EntityDescriptorType entityDescriptor = this.readEntityDescriptor(reader);
        String entityId = entityDescriptor.getEntityID();
        SPSSODescriptorType SPSSODescriptor = (SPSSODescriptorType)entityDescriptor.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor().get(0);
        return this.addExternalServiceProvider(entityId, SPSSODescriptor);
    }

    @Override
    public List<SamlExternalEntity> getExternalSamlEntities() {
        LinkedList<SamlExternalEntity> samlEntities = new LinkedList<SamlExternalEntity>();
        for (SamlExternalServiceProvider sp : this.serviceProviders) {
            samlEntities.add(sp);
        }
        return samlEntities;
    }

    @Override
    public boolean isWantAuthnRequestsSigned() {
        return this.wantAuthnRequestsSigned;
    }

    @Override
    public void setWantAuthnRequestsSigned(boolean wantAuthnRequestsSigned) {
        this.wantAuthnRequestsSigned = wantAuthnRequestsSigned;
    }

    @Override
    public SamlExternalServiceProvider getExternalSamlEntityByEntityId(String entityId) {
        for (SamlExternalServiceProvider serviceProvider : this.serviceProviders) {
            if (!serviceProvider.getEntityId().equals(entityId)) continue;
            return serviceProvider;
        }
        return null;
    }

    @Override
    public void writeMetaData(Writer writer) {
        try {
            ObjectFactory metaDataFactory = new ObjectFactory();
            IndexedEndpointType ssoRedirectEndpoint = metaDataFactory.createIndexedEndpointType();
            ssoRedirectEndpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            ssoRedirectEndpoint.setLocation(this.getServiceURL(SamlServiceType.SAML_SINGLE_SIGN_ON_SERVICE));
            IndexedEndpointType ssoPostEndpoint = metaDataFactory.createIndexedEndpointType();
            ssoPostEndpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            ssoPostEndpoint.setLocation(this.getServiceURL(SamlServiceType.SAML_SINGLE_SIGN_ON_SERVICE));
            IDPSSODescriptorType idpSsoDescriptor = metaDataFactory.createIDPSSODescriptorType();
            idpSsoDescriptor.getSingleSignOnService().add(ssoRedirectEndpoint);
            idpSsoDescriptor.getSingleSignOnService().add(ssoPostEndpoint);
            this.addSloEndpointsToMetaData(idpSsoDescriptor);
            idpSsoDescriptor.setWantAuthnRequestsSigned(this.isWantAuthnRequestsSigned());
            idpSsoDescriptor.getProtocolSupportEnumeration().add("urn:oasis:names:tc:SAML:2.0:protocol");
            this.addNameIDFormatsToMetaData(idpSsoDescriptor);
            this.addKeyDescriptorToMetaData(idpSsoDescriptor);
            EntityDescriptorType entityDescriptor = metaDataFactory.createEntityDescriptorType();
            entityDescriptor.setEntityID(this.getEntityId());
            entityDescriptor.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor().add(idpSsoDescriptor);
            Marshaller marshaller = this.metaDataJaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(metaDataFactory.createEntityDescriptor(entityDescriptor), writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Dialogued(join=true)
    public void authenticationSucceeded(SamlIdpSession session, HttpServletResponse response) {
        session.getServiceProviders().add((SamlExternalServiceProvider)((SamlDialogue)this.samlDialogue.get()).getExternalProvider());
        this.samlIdpSingleSignOnService.handleSucceededAuthentication(session, response);
    }

    @Override
    @Dialogued(join=true)
    public void authenticationFailed(HttpServletResponse response) {
        this.samlIdpSingleSignOnService.handleFailedAuthentication(response);
    }

    @Override
    public Set<SamlIdpSession> getSessions() {
        HashSet<SamlIdpSession> sessions = new HashSet<SamlIdpSession>();
        sessions.addAll(this.samlIdpSessions.getSessions());
        return sessions;
    }

    @Override
    public SamlIdpSession localLogin(SamlNameId nameId, List<AttributeType> attributes) {
        return this.createSession(nameId, attributes);
    }

    @Override
    public SamlNameId createNameId(String value, String format, String qualifier) {
        return new SamlNameIdImpl(value, format, qualifier);
    }

    private SamlIdpSession createSession(SamlNameId nameId, List<AttributeType> attributes) {
        SamlPrincipalImpl samlPrincipal = new SamlPrincipalImpl();
        samlPrincipal.setNameId(nameId);
        if (attributes != null) {
            samlPrincipal.setAttributes(attributes);
        } else {
            samlPrincipal.setAttributes(new LinkedList<AttributeType>());
        }
        return this.samlIdpSessions.addSession(samlPrincipal);
    }

    @Override
    @Dialogued(join=true)
    public void remoteLogin(String spEntityId, SamlIdpSession session, String remoteUrl, HttpServletResponse response) {
        for (SamlExternalServiceProvider sp : session.getServiceProviders()) {
            if (!sp.getEntityId().equals(spEntityId)) continue;
            throw new RuntimeException("Service provider " + spEntityId + " is already a session participant.");
        }
        session.getServiceProviders().add(this.getExternalSamlEntityByEntityId(spEntityId));
        this.samlIdpSingleSignOnService.remoteLogin(spEntityId, session, remoteUrl, response);
    }

    @Override
    public void localLogout(SamlIdpSession session) {
        this.samlIdpSessions.removeSession((SamlIdpSessionImpl)session);
    }

    @Override
    @Dialogued(join=true)
    public void globalLogout(SamlIdpSession session, HttpServletResponse response) {
        SamlPrincipal principal = session.getPrincipal();
        this.samlIdpSingleSignLogoutService.handleIDPInitiatedSingleLogout(principal, Arrays.asList(((SamlIdpSessionImpl)session).getSessionIndex()), response);
    }

    @Override
    public SamlIdpOrSp getIdpOrSp() {
        return SamlIdpOrSp.IDP;
    }
}

