/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml.idp;

import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.security.external.InvalidRequestException;
import org.jboss.seam.security.external.ResponseHandler;
import org.jboss.seam.security.external.dialogues.DialogueBean;
import org.jboss.seam.security.external.dialogues.api.Dialogued;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.AuthnRequestType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.RequestAbstractType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.StatusResponseType;
import org.jboss.seam.security.external.saml.SamlDialogue;
import org.jboss.seam.security.external.saml.SamlEntityBean;
import org.jboss.seam.security.external.saml.SamlExternalEntity;
import org.jboss.seam.security.external.saml.SamlMessageFactory;
import org.jboss.seam.security.external.saml.SamlMessageSender;
import org.jboss.seam.security.external.saml.SamlProfile;
import org.jboss.seam.security.external.saml.SamlService;
import org.jboss.seam.security.external.saml.api.SamlIdpSession;
import org.jboss.seam.security.external.saml.sp.SamlExternalIdentityProvider;
import org.jboss.seam.security.external.spi.SamlIdentityProviderSpi;

public class SamlIdpSingleSignOnService {
    @Inject
    private SamlMessageFactory samlMessageFactory;
    @Inject
    private SamlMessageSender samlMessageSender;
    @Inject
    private Instance<SamlIdentityProviderSpi> samlIdentityProviderSpi;
    @Inject
    private DialogueBean dialogue;
    @Inject
    private SamlDialogue samlDialogue;
    @Inject
    private Instance<SamlEntityBean> samlEntityBean;
    @Inject
    private ResponseHandler responseHandler;

    public void processSPRequest(HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestAbstractType request) throws InvalidRequestException {
        if (!(request instanceof AuthnRequestType)) {
            throw new InvalidRequestException("Request should be an authentication request.");
        }
        ((SamlIdentityProviderSpi)this.samlIdentityProviderSpi.get()).authenticate(this.responseHandler.createResponseHolder(httpResponse));
    }

    public void handleSucceededAuthentication(SamlIdpSession session, HttpServletResponse response) {
        this.sendAuthenticationResponse(this.samlDialogue.getExternalProvider(), session, false, response);
    }

    private void sendAuthenticationResponse(SamlExternalEntity serviceProvider, SamlIdpSession session, boolean failed, HttpServletResponse response) {
        StatusResponseType statusResponse;
        if (failed) {
            statusResponse = this.samlMessageFactory.createStatusResponse("urn:oasis:names:tc:SAML:2.0:status:Responder", null);
        } else {
            SamlService service = serviceProvider.getService(SamlProfile.SINGLE_SIGN_ON);
            statusResponse = this.samlMessageFactory.createResponse(session, this.samlMessageSender.getEndpoint(service));
        }
        this.samlMessageSender.sendResponse(serviceProvider, statusResponse, SamlProfile.SINGLE_SIGN_ON, response);
        this.dialogue.setFinished(true);
    }

    public void handleFailedAuthentication(HttpServletResponse response) {
        this.sendAuthenticationResponse(this.samlDialogue.getExternalProvider(), null, true, response);
    }

    @Dialogued
    public void sendAuthenticationResponseToIDP(SamlExternalIdentityProvider idp, HttpServletResponse response) {
        AuthnRequestType authnRequest = this.samlMessageFactory.createAuthnRequest();
        this.samlDialogue.setExternalProvider(idp);
        this.samlMessageSender.sendRequest(idp, SamlProfile.SINGLE_SIGN_ON, authnRequest, response);
    }

    public void remoteLogin(String spEntityId, SamlIdpSession session, String remoteUrl, HttpServletResponse response) {
        SamlExternalEntity serviceProvider = ((SamlEntityBean)this.samlEntityBean.get()).getExternalSamlEntityByEntityId(spEntityId);
        this.samlDialogue.setExternalProvider(serviceProvider);
        this.samlDialogue.setExternalProviderRelayState(remoteUrl);
        this.sendAuthenticationResponse(serviceProvider, session, false, response);
    }
}

