/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external;

import java.net.URL;
import java.util.List;
import java.util.Map;
import org.jboss.seam.security.external.openid.api.OpenIdPrincipal;

public class OpenIdPrincipalImpl
implements OpenIdPrincipal {
    private String identifier;
    private URL openIdProvider;
    private Map<String, List<String>> attributeValues;

    public OpenIdPrincipalImpl(String identifier, URL openIdProvider, Map<String, List<String>> attributeValues) {
        this.identifier = identifier;
        this.openIdProvider = openIdProvider;
        this.attributeValues = attributeValues;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    @Override
    public URL getOpenIdProvider() {
        return this.openIdProvider;
    }

    @Override
    public Map<String, List<String>> getAttributeValues() {
        return this.attributeValues;
    }

    @Override
    public String getAttribute(String alias) {
        if (this.attributeValues == null) {
            return null;
        }
        List<String> values = this.attributeValues.get(alias);
        if (values == null || values.size() == 0) {
            return null;
        }
        if (values.size() == 1) {
            return this.attributeValues.get(alias).get(0);
        }
        throw new RuntimeException("Attribute has multiple values");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenIdPrincipalImpl other = (OpenIdPrincipalImpl)obj;
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
    }
}

