/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.dialogues;

import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.jboss.seam.security.external.dialogues.DialogueBean;
import org.jboss.seam.security.external.dialogues.DialogueContextExtension;
import org.jboss.seam.security.external.dialogues.api.DialogueManager;
import org.jboss.solder.servlet.event.Destroyed;
import org.jboss.solder.servlet.event.Initialized;

public class DialogueManagerBean
implements DialogueManager {
    @Inject
    private DialogueContextExtension dialogueContextExtension;
    @Inject
    private Instance<DialogueBean> dialogue;

    public void servletInitialized(@Observes @Initialized ServletContext context) {
        this.dialogueContextExtension.getDialogueContext().initialize(context);
    }

    public void servletDestroyed(@Observes @Destroyed ServletContext context) {
        this.dialogueContextExtension.getDialogueContext().destroy();
    }

    @Override
    public void beginDialogue() {
        String dialogueId = this.dialogueContextExtension.getDialogueContext().create();
        ((DialogueBean)this.dialogue.get()).setId(dialogueId);
    }

    @Override
    public void endDialogue() {
        this.dialogueContextExtension.getDialogueContext().remove();
    }

    @Override
    public void attachDialogue(String requestId) {
        this.dialogueContextExtension.getDialogueContext().attach(requestId);
    }

    @Override
    public void detachDialogue() {
        if (((DialogueBean)this.dialogue.get()).isFinished()) {
            this.endDialogue();
        } else {
            this.dialogueContextExtension.getDialogueContext().detach();
        }
    }

    @Override
    public boolean isExistingDialogue(String dialogueId) {
        return this.dialogueContextExtension.getDialogueContext().isExistingDialogue(dialogueId);
    }

    @Override
    public boolean isAttached() {
        return this.dialogueContextExtension.getDialogueContext().isAttached();
    }
}

