/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.openid;

import java.io.Writer;
import java.util.List;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.jboss.seam.security.external.EntityBean;
import org.jboss.seam.security.external.JaxbContext;
import org.jboss.seam.security.external.OpenIdRequestedAttributeImpl;
import org.jboss.seam.security.external.dialogues.api.Dialogued;
import org.jboss.seam.security.external.jaxb.xrds.ObjectFactory;
import org.jboss.seam.security.external.jaxb.xrds.Service;
import org.jboss.seam.security.external.jaxb.xrds.Type;
import org.jboss.seam.security.external.jaxb.xrds.URIPriorityAppendPattern;
import org.jboss.seam.security.external.jaxb.xrds.XRD;
import org.jboss.seam.security.external.jaxb.xrds.XRDS;
import org.jboss.seam.security.external.openid.OpenIdConfiguration;
import org.jboss.seam.security.external.openid.OpenIdRpAuthenticationService;
import org.jboss.seam.security.external.openid.OpenIdRpBeanApi;
import org.jboss.seam.security.external.openid.OpenIdService;
import org.jboss.seam.security.external.openid.api.OpenIdRequestedAttribute;

@Typed(value={OpenIdRpBean.class})
public class OpenIdRpBean
extends EntityBean
implements OpenIdRpBeanApi {
    @Inject
    private OpenIdRpAuthenticationService openIdSingleLoginSender;
    @Inject
    private ServletContext servletContext;
    private String returnToPath;
    @Inject
    @JaxbContext(value={ObjectFactory.class})
    private JAXBContext jaxbContext;

    @Inject
    public void init(OpenIdConfiguration config) {
        this.setHostName(config.getHostName());
        this.setPort(config.getPort());
        this.setProtocol(config.getProtocol());
        this.setReturnToPath(config.getReturnToPath());
    }

    public String getReturnToPath() {
        return this.returnToPath;
    }

    public void setReturnToPath(String value) {
        this.returnToPath = value;
    }

    @Override
    @Dialogued(join=true)
    public void login(String identifier, List<OpenIdRequestedAttribute> attributes, HttpServletResponse response) {
        this.openIdSingleLoginSender.sendAuthRequest(identifier, attributes, response);
    }

    @Override
    public String getServiceURL(OpenIdService service) {
        String path = this.servletContext.getContextPath() + (this.returnToPath != null ? this.returnToPath : "/openid/RP/" + service.getName());
        return this.createURL(path);
    }

    @Override
    public String getRealm() {
        return this.createURL("");
    }

    @Override
    public String getXrdsURL() {
        return this.getServiceURL(OpenIdService.XRDS_SERVICE);
    }

    @Override
    public void writeRpXrds(Writer writer) {
        try {
            ObjectFactory objectFactory = new ObjectFactory();
            XRDS xrds = objectFactory.createXRDS();
            XRD xrd = objectFactory.createXRD();
            Type type = objectFactory.createType();
            type.setValue("http://specs.openid.net/auth/2.0/return_to");
            URIPriorityAppendPattern uri = objectFactory.createURIPriorityAppendPattern();
            uri.setValue(this.getServiceURL(OpenIdService.OPEN_ID_SERVICE));
            Service service = objectFactory.createService();
            service.getType().add(type);
            service.getURI().add(uri);
            xrd.getService().add(service);
            xrds.getOtherelement().add(xrd);
            Marshaller marshaller = this.jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)xrds, writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public OpenIdRequestedAttribute createOpenIdRequestedAttribute(String alias, String typeUri, boolean required, Integer count) {
        return new OpenIdRequestedAttributeImpl(alias, typeUri, required, count);
    }
}

