/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.openid;

import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.security.external.InvalidRequestException;
import org.jboss.seam.security.external.ResponseHandler;
import org.jboss.seam.security.external.openid.OpenIdProviderAuthenticationService;
import org.jboss.seam.security.external.openid.OpenIdProviderBeanApi;
import org.jboss.seam.security.external.openid.OpenIdProviderOrRelyingParty;
import org.jboss.seam.security.external.openid.OpenIdRpAuthenticationService;
import org.jboss.seam.security.external.openid.OpenIdRpBeanApi;
import org.jboss.seam.security.external.openid.OpenIdService;
import org.jboss.solder.logging.Logger;

public class OpenIdServlet
extends HttpServlet {
    private static final long serialVersionUID = -3058316157797375740L;
    private Logger log = Logger.getLogger(OpenIdServlet.class);
    @Inject
    private ResponseHandler responseHandler;
    @Inject
    private OpenIdProviderAuthenticationService openIdProviderAuthenticationService;
    @Inject
    private OpenIdRpAuthenticationService openIdRpAuthenticationService;
    @Inject
    private Instance<OpenIdRpBeanApi> rpBean;
    @Inject
    private Instance<OpenIdProviderBeanApi> opBean;

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetOrPost(request, response);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGetOrPost(request, response);
    }

    private void doGetOrPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            this.handleMessage(request, response);
        }
        catch (InvalidRequestException e) {
            response.sendError(400, e.getDescription());
            this.log.infof("Bad request received from %s: %s", (Object)request.getRemoteHost(), (Object)e.getDescription());
        }
    }

    private void handleMessage(HttpServletRequest httpRequest, HttpServletResponse response) throws InvalidRequestException {
        Matcher matcher = Pattern.compile("/(OP|RP)/([^/]*?)$").matcher(httpRequest.getRequestURI());
        boolean found = matcher.find();
        if (!found) {
            this.responseHandler.sendError(404, "No service endpoint exists for this URL.", response);
            return;
        }
        OpenIdProviderOrRelyingParty opOrRp = OpenIdProviderOrRelyingParty.valueOf(matcher.group(1));
        OpenIdService service = OpenIdService.getByName(matcher.group(2));
        if (service == null) {
            this.responseHandler.sendError(404, "No service endpoint exists for this URL.", response);
            return;
        }
        switch (service) {
            case OPEN_ID_SERVICE: {
                if (opOrRp == OpenIdProviderOrRelyingParty.OP) {
                    this.openIdProviderAuthenticationService.handleIncomingMessage(httpRequest, response);
                    break;
                }
                this.openIdRpAuthenticationService.handleIncomingMessage(httpRequest, response);
                break;
            }
            case XRDS_SERVICE: {
                if (opOrRp == OpenIdProviderOrRelyingParty.OP) {
                    ((OpenIdProviderBeanApi)this.opBean.get()).writeOpIdentifierXrds(this.responseHandler.getWriter("application/xrds+xml", response));
                    break;
                }
                ((OpenIdRpBeanApi)this.rpBean.get()).writeRpXrds(this.responseHandler.getWriter("application/xrds+xml", response));
                break;
            }
            default: {
                throw new RuntimeException("Unsupported service " + (Object)((Object)service));
            }
        }
    }

    public void destroy() {
    }
}

