/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external;

import java.io.IOException;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.security.external.api.ResponseHolder;

public class ResponseHolderImpl
implements ResponseHolder {
    private HttpServletResponse response;
    private String dialogueId;

    public ResponseHolderImpl(HttpServletResponse response, String dialogueId) {
        this.response = response;
        this.dialogueId = dialogueId;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    @Override
    public void redirectWithDialoguePropagation(String url) {
        if (this.dialogueId != null) {
            url = this.addDialogueIdToUrl(url);
        }
        String encodedUrl = this.response.encodeURL(url);
        try {
            this.response.sendRedirect(encodedUrl);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String addDialogueIdToUrl(String url) {
        if (this.dialogueId != null) {
            String paramName = "dialogueId";
            int queryStringIndex = url.indexOf("?");
            if (queryStringIndex < 0 || url.indexOf(paramName + "=", queryStringIndex) < 0) {
                url = url + (queryStringIndex < 0 ? "?" : "&") + paramName + "=" + this.dialogueId;
            }
        }
        return url;
    }
}

