/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.dialogues;

import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.seam.security.external.dialogues.api.DialogueManager;
import org.jboss.seam.security.external.dialogues.api.Dialogued;

@Dialogued
@Interceptor
public class DialoguedInterceptor {
    @Inject
    private DialogueManager manager;

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        Object result;
        boolean joined;
        boolean join = ctx.getMethod().getAnnotation(Dialogued.class).join();
        if (!join || !this.manager.isAttached()) {
            this.manager.beginDialogue();
            joined = false;
        } else {
            joined = true;
        }
        try {
            result = ctx.proceed();
        }
        catch (Exception e) {
            if (!joined) {
                this.manager.detachDialogue();
            }
            throw e;
        }
        if (!joined) {
            this.manager.detachDialogue();
        }
        return result;
    }
}

