/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.oauth;

import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.BeanManager;
import javax.faces.context.FacesContext;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.security.AuthenticationException;
import org.jboss.seam.security.Authenticator;
import org.jboss.seam.security.BaseAuthenticator;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.events.DeferredAuthenticationEvent;
import org.jboss.seam.security.external.oauth.OAuthUser;
import org.jboss.seam.security.external.oauth.api.OAuthAuthenticator;
import org.jboss.seam.security.management.picketlink.IdentitySessionProducer;
import org.jboss.seam.social.MultiServicesManager;
import org.jboss.seam.social.SeamSocialExtension;
import org.jboss.seam.social.SocialNetworkServicesHub;
import org.jboss.seam.social.oauth.OAuthService;
import org.jboss.seam.social.oauth.OAuthSession;
import org.jboss.solder.core.Requires;
import org.jboss.solder.logging.Logger;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.common.exception.FeatureNotSupportedException;
import org.picketlink.idm.common.exception.IdentityException;

@Requires(value={"org.jboss.seam.social.oauth.OAuthService"})
@Named(value="oauthAuthenticator")
@SessionScoped
public class OAuthAuthenticatorImpl
extends BaseAuthenticator
implements OAuthAuthenticator,
Authenticator,
Serializable {
    private static final long serialVersionUID = 3431696230531662201L;
    @Inject
    @Any
    private Instance<OAuthService> serviceInstances;
    private String serviceName = null;
    private boolean identityManaged = true;
    @Inject
    Instance<Identity> identity;
    @Inject
    MultiServicesManager multiServicesManager;
    @Inject
    Instance<IdentitySession> identitySession;
    @Inject
    Instance<IdentitySessionProducer> identitySessionProducer;
    @Inject
    Logger log;
    @Inject
    SeamSocialExtension extension;
    @Inject
    BeanManager beanManager;

    public boolean isIdentityManaged() {
        return this.identityManaged;
    }

    public void setIdentityManaged(boolean identityManaged) {
        this.identityManaged = identityManaged;
    }

    @Override
    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public List<String> getListOfServices() {
        return this.multiServicesManager.getListOfServices();
    }

    private OAuthService getUnambiguousService() {
        if (this.extension.getSocialRelated().size() == 1) {
            String name = (String)Iterables.getOnlyElement((Iterable)this.extension.getSocialRelated());
            Annotation qualifier = (Annotation)SeamSocialExtension.getServicesToQualifier().inverse().get((Object)name);
            return (OAuthService)this.serviceInstances.select(new Annotation[]{qualifier}).get();
        }
        throw new IllegalStateException("Service name not set and there is no unambiguous OAuthService available");
    }

    private OAuthService getCurrentService() {
        if (this.serviceName == null) {
            return this.getUnambiguousService();
        }
        return this.multiServicesManager.getCurrentService();
    }

    public void authenticate() {
        String authorizationUrl;
        if (this.serviceName == null) {
            this.log.debug((Object)"Service name null, authenticating with unamgiguous oauthService");
            OAuthService oauthService = this.getUnambiguousService();
            authorizationUrl = oauthService.getAuthorizationUrl();
        } else {
            this.log.debug((Object)("authenticating service \"" + this.serviceName + "\""));
            authorizationUrl = this.multiServicesManager.initNewSession(this.serviceName);
        }
        try {
            FacesContext.getCurrentInstance().getExternalContext().redirect(authorizationUrl);
            this.setStatus(Authenticator.AuthenticationStatus.DEFERRED);
        }
        catch (IOException e) {
            this.log.error((Object)"Failed to redirect ", (Throwable)e);
            this.setStatus(Authenticator.AuthenticationStatus.FAILURE);
        }
    }

    @Override
    public String getVerifierParamName() {
        return this.getCurrentHub().getVerifierParamName();
    }

    private SocialNetworkServicesHub getCurrentHub() {
        return this.multiServicesManager.getCurrentServiceHub();
    }

    @Override
    public String getVerifier() {
        return this.getCurrentService().getVerifier();
    }

    @Override
    public void setVerifier(String verifier) {
        this.getCurrentService().setVerifier(verifier);
    }

    @Override
    public void connect() {
        OAuthSession currentSession;
        OAuthService currentService;
        if (this.serviceName != null) {
            MultiServicesManager manager = this.multiServicesManager;
            manager.connectCurrentService();
            currentService = manager.getCurrentService();
            currentSession = manager.getCurrentSession();
        } else {
            currentService = this.getUnambiguousService();
            currentSession = currentService.getSession();
            currentService.initAccessToken();
        }
        OAuthUser user = new OAuthUser(currentService.getType(), currentSession.getUserProfile());
        if (this.isIdentityManaged()) {
            this.setStatus(Authenticator.AuthenticationStatus.FAILURE);
            if (((IdentitySessionProducer)this.identitySessionProducer.get()).isConfigured()) {
                this.validateManagedUser(user);
            }
        }
        this.setUser(user);
        this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
        this.beanManager.fireEvent((Object)new DeferredAuthenticationEvent(true), new Annotation[0]);
    }

    protected void validateManagedUser(OAuthUser principal) {
        block8: {
            IdentitySession session = (IdentitySession)this.identitySession.get();
            try {
                if (session.getPersistenceManager().findUser(principal.getId()) != null) break block8;
                User user = session.getPersistenceManager().createUser(principal.getId());
                try {
                    Collection roleTypes = session.getRoleManager().findUserRoleTypes(user);
                    for (RoleType roleType : roleTypes) {
                        for (Role role : session.getRoleManager().findRoles((IdentityType)user, roleType)) {
                            ((Identity)this.identity.get()).addRole(role.getRoleType().getName(), role.getGroup().getName(), role.getGroup().getGroupType());
                        }
                    }
                    for (Group g : session.getRelationshipManager().findAssociatedGroups(user)) {
                        ((Identity)this.identity.get()).addGroup(g.getName(), g.getGroupType());
                    }
                }
                catch (FeatureNotSupportedException ex) {
                    throw new AuthenticationException("Error loading user's roles and groups", (Throwable)ex);
                }
                catch (IdentityException ex) {
                    throw new AuthenticationException("Error loading user's roles and groups", (Throwable)ex);
                }
            }
            catch (IdentityException ex) {
                throw new AuthenticationException("Error locating User record for OAuth user", (Throwable)ex);
            }
        }
    }
}

