/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.openid;

import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.security.AuthenticationException;
import org.jboss.seam.security.Authenticator;
import org.jboss.seam.security.BaseAuthenticator;
import org.jboss.seam.security.Identity;
import org.jboss.seam.security.external.openid.OpenIdUser;
import org.jboss.seam.security.external.openid.api.OpenIdPrincipal;
import org.jboss.seam.security.external.openid.api.OpenIdRelyingPartyApi;
import org.jboss.seam.security.external.openid.api.OpenIdRequestedAttribute;
import org.jboss.seam.security.external.openid.providers.OpenIdProvider;
import org.jboss.seam.security.management.picketlink.IdentitySessionProducer;
import org.jboss.solder.logging.Logger;
import org.picketlink.idm.api.Group;
import org.picketlink.idm.api.IdentitySession;
import org.picketlink.idm.api.IdentityType;
import org.picketlink.idm.api.Role;
import org.picketlink.idm.api.RoleType;
import org.picketlink.idm.api.User;
import org.picketlink.idm.common.exception.FeatureNotSupportedException;
import org.picketlink.idm.common.exception.IdentityException;

@Named(value="openIdAuthenticator")
@SessionScoped
public class OpenIdAuthenticator
extends BaseAuthenticator
implements Authenticator,
Serializable {
    private static final long serialVersionUID = 4669651866032932651L;
    @Inject
    Instance<OpenIdRelyingPartyApi> openIdApiInstance;
    @Inject
    List<OpenIdProvider> providers;
    @Inject
    Logger log;
    @Inject
    HttpServletResponse response;
    @Inject
    Instance<IdentitySession> identitySession;
    @Inject
    IdentitySessionProducer identitySessionProducer;
    @Inject
    Identity identity;
    private boolean identityManaged = true;
    private String providerCode;

    public boolean isIdentityManaged() {
        return this.identityManaged;
    }

    public void setIdentityManaged(boolean identityManaged) {
        this.identityManaged = identityManaged;
    }

    public String getProviderCode() {
        return this.providerCode;
    }

    public void setProviderCode(String providerCode) {
        this.providerCode = providerCode;
    }

    protected OpenIdProvider getSelectedProvider() {
        if (this.providerCode != null) {
            for (OpenIdProvider provider : this.providers) {
                if (!this.providerCode.equals(provider.getCode())) continue;
                return provider;
            }
        }
        return null;
    }

    public void authenticate() {
        OpenIdProvider selectedProvider = this.getSelectedProvider();
        if (selectedProvider == null) {
            throw new IllegalStateException("No OpenID provider has been selected");
        }
        OpenIdRelyingPartyApi openIdApi = (OpenIdRelyingPartyApi)this.openIdApiInstance.get();
        LinkedList<OpenIdRequestedAttribute> attributes = new LinkedList<OpenIdRequestedAttribute>();
        selectedProvider.requestAttributes(openIdApi, attributes);
        openIdApi.login(selectedProvider.getUrl(), attributes, this.getResponse());
        this.setStatus(Authenticator.AuthenticationStatus.DEFERRED);
    }

    protected HttpServletResponse getResponse() {
        return this.response;
    }

    public List<OpenIdProvider> getProviders() {
        return this.providers;
    }

    public void success(OpenIdPrincipal principal) {
        OpenIdUser user = new OpenIdUser(principal);
        if (this.isIdentityManaged()) {
            this.setStatus(Authenticator.AuthenticationStatus.FAILURE);
            if (this.identitySessionProducer.isConfigured()) {
                this.validateManagedUser(principal);
            }
        }
        this.setUser(user);
        this.setStatus(Authenticator.AuthenticationStatus.SUCCESS);
    }

    protected void validateManagedUser(OpenIdPrincipal principal) {
        block9: {
            IdentitySession session = (IdentitySession)this.identitySession.get();
            try {
                if (session.getPersistenceManager().findUser(principal.getIdentifier()) != null) break block9;
                User user = session.getPersistenceManager().createUser(principal.getIdentifier());
                for (String alias : principal.getAttributeValues().keySet()) {
                    session.getAttributesManager().addAttribute((IdentityType)user, alias, (Object)principal.getAttribute(alias));
                }
                try {
                    Collection roleTypes = session.getRoleManager().findUserRoleTypes(user);
                    for (RoleType roleType : roleTypes) {
                        for (Role role : session.getRoleManager().findRoles((IdentityType)user, roleType)) {
                            this.identity.addRole(role.getRoleType().getName(), role.getGroup().getName(), role.getGroup().getGroupType());
                        }
                    }
                    for (Group g : session.getRelationshipManager().findAssociatedGroups(user)) {
                        this.identity.addGroup(g.getName(), g.getGroupType());
                    }
                }
                catch (FeatureNotSupportedException ex) {
                    throw new AuthenticationException("Error loading user's roles and groups", (Throwable)ex);
                }
                catch (IdentityException ex) {
                    throw new AuthenticationException("Error loading user's roles and groups", (Throwable)ex);
                }
            }
            catch (IdentityException ex) {
                throw new AuthenticationException("Error locating User record for OpenID user", (Throwable)ex);
            }
        }
    }
}

