/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.openid;

import java.io.IOException;
import java.io.Writer;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.seam.security.external.InvalidRequestException;
import org.jboss.seam.security.external.OpenIdRequestedAttributeImpl;
import org.jboss.seam.security.external.ResponseHandler;
import org.jboss.seam.security.external.dialogues.DialogueBean;
import org.jboss.seam.security.external.dialogues.api.DialogueManager;
import org.jboss.seam.security.external.openid.OpenIdProviderBeanApi;
import org.jboss.seam.security.external.openid.OpenIdProviderRequest;
import org.jboss.seam.security.external.openid.api.OpenIdRequestedAttribute;
import org.jboss.seam.security.external.spi.OpenIdProviderSpi;
import org.openid4java.association.AssociationException;
import org.openid4java.message.AuthRequest;
import org.openid4java.message.AuthSuccess;
import org.openid4java.message.DirectError;
import org.openid4java.message.Message;
import org.openid4java.message.MessageException;
import org.openid4java.message.MessageExtension;
import org.openid4java.message.ParameterList;
import org.openid4java.message.ax.FetchRequest;
import org.openid4java.message.ax.FetchResponse;
import org.openid4java.server.RealmVerifier;
import org.openid4java.server.ServerException;
import org.openid4java.server.ServerManager;

public class OpenIdProviderAuthenticationService {
    @Inject
    private Instance<OpenIdProviderRequest> openIdProviderRequest;
    @Inject
    private Instance<ServerManager> openIdServerManager;
    @Inject
    private Instance<OpenIdProviderSpi> openIdProviderSpi;
    @Inject
    private ResponseHandler responseHandler;
    @Inject
    private DialogueManager dialogueManager;
    @Inject
    private Instance<DialogueBean> dialogue;
    @Inject
    private Instance<OpenIdProviderBeanApi> opBean;

    public void handleIncomingMessage(HttpServletRequest httpRequest, HttpServletResponse httpResponse) throws InvalidRequestException {
        ParameterList parameterList = new ParameterList(httpRequest.getParameterMap());
        String mode = parameterList.getParameterValue("openid.mode");
        if ("associate".equals(mode)) {
            Message associationResponse = ((ServerManager)this.openIdServerManager.get()).associationResponse(parameterList);
            this.writeMessageToResponse(associationResponse, httpResponse);
        } else if ("checkid_setup".equals(mode) || "checkid_immediate".equals(mode)) {
            this.dialogueManager.beginDialogue();
            String claimedIdentifier = parameterList.getParameterValue("openid.claimed_id");
            String opLocalIdentifier = parameterList.getParameterValue("openid.identity");
            ((OpenIdProviderRequest)this.openIdProviderRequest.get()).setParameterList(parameterList);
            ((OpenIdProviderRequest)this.openIdProviderRequest.get()).setClaimedIdentifier(claimedIdentifier);
            MessageExtension ext = null;
            try {
                AuthRequest authReq = AuthRequest.createAuthRequest((ParameterList)parameterList, (RealmVerifier)((ServerManager)this.openIdServerManager.get()).getRealmVerifier());
                if (authReq.hasExtension("http://openid.net/srv/ax/1.0")) {
                    ext = authReq.getExtension("http://openid.net/srv/ax/1.0");
                }
            }
            catch (MessageException e) {
                throw new RuntimeException(e);
            }
            if (ext instanceof FetchRequest) {
                FetchRequest fetchRequest = (FetchRequest)ext;
                LinkedList<OpenIdRequestedAttribute> requestedAttributes = new LinkedList<OpenIdRequestedAttribute>();
                this.handleAttributeRequests(fetchRequest, requestedAttributes, false);
                this.handleAttributeRequests(fetchRequest, requestedAttributes, true);
                ((OpenIdProviderRequest)this.openIdProviderRequest.get()).setRequestedAttributes(requestedAttributes);
                ((OpenIdProviderRequest)this.openIdProviderRequest.get()).setFetchRequest(fetchRequest);
            }
            if (claimedIdentifier != null && opLocalIdentifier != null) {
                boolean immediate = "checkid_immediate".equals(mode);
                String realm = parameterList.getParameterValue("openid.realm");
                if (realm == null) {
                    realm = parameterList.getParameterValue("openid.return_to");
                }
                if (opLocalIdentifier.equals("http://specs.openid.net/auth/2.0/identifier_select")) {
                    ((OpenIdProviderSpi)this.openIdProviderSpi.get()).authenticate(realm, null, immediate, this.responseHandler.createResponseHolder(httpResponse));
                } else {
                    String userName = ((OpenIdProviderBeanApi)this.opBean.get()).getUserNameFromOpLocalIdentifier(opLocalIdentifier);
                    ((OpenIdProviderSpi)this.openIdProviderSpi.get()).authenticate(realm, userName, immediate, this.responseHandler.createResponseHolder(httpResponse));
                }
            } else {
                DirectError associationResponse = DirectError.createDirectError((String)"Invalid request; claimed_id or identity attribute is missing");
                this.writeMessageToResponse((Message)associationResponse, httpResponse);
            }
            this.dialogueManager.detachDialogue();
        } else if ("check_authentication".equals(mode)) {
            Message associationResponse = ((ServerManager)this.openIdServerManager.get()).verify(parameterList);
            this.writeMessageToResponse(associationResponse, httpResponse);
        } else {
            DirectError associationResponse = DirectError.createDirectError((String)"Unknown request");
            this.writeMessageToResponse((Message)associationResponse, httpResponse);
        }
    }

    private void handleAttributeRequests(FetchRequest fetchRequest, List<OpenIdRequestedAttribute> requestedAttributes, boolean required) {
        Map attributes = fetchRequest.getAttributes(required);
        for (Map.Entry entry : attributes.entrySet()) {
            OpenIdRequestedAttributeImpl requestedAttribute = new OpenIdRequestedAttributeImpl();
            requestedAttribute.setAlias((String)entry.getKey());
            requestedAttribute.setTypeUri((String)entry.getValue());
            requestedAttribute.setRequired(required);
            requestedAttribute.setCount(fetchRequest.getCount((String)entry.getKey()));
            requestedAttributes.add(requestedAttribute);
        }
    }

    public void sendAuthenticationResponse(boolean authenticationSuccesful, Map<String, List<String>> attributeValues, HttpServletResponse response) {
        ParameterList parameterList = ((OpenIdProviderRequest)this.openIdProviderRequest.get()).getParameterList();
        String userName = ((OpenIdProviderRequest)this.openIdProviderRequest.get()).getUserName();
        String opLocalIdentifier = ((OpenIdProviderBeanApi)this.opBean.get()).getOpLocalIdentifierForUserName(userName);
        String claimedIdentifier = ((OpenIdProviderRequest)this.openIdProviderRequest.get()).getClaimedIdentifier();
        if (claimedIdentifier.equals("http://specs.openid.net/auth/2.0/identifier_select")) {
            claimedIdentifier = opLocalIdentifier;
        }
        if (response instanceof DirectError) {
            Message authResponse = ((ServerManager)this.openIdServerManager.get()).authResponse(parameterList, opLocalIdentifier, claimedIdentifier, authenticationSuccesful, true);
            this.writeMessageToResponse(authResponse, response);
        } else {
            Message authResponse = ((ServerManager)this.openIdServerManager.get()).authResponse(parameterList, opLocalIdentifier, claimedIdentifier, authenticationSuccesful, false);
            if (((OpenIdProviderRequest)this.openIdProviderRequest.get()).getRequestedAttributes() != null) {
                try {
                    FetchResponse fetchResponse = FetchResponse.createFetchResponse((FetchRequest)((OpenIdProviderRequest)this.openIdProviderRequest.get()).getFetchRequest(), attributeValues);
                    authResponse.addExtension((MessageExtension)fetchResponse);
                }
                catch (MessageException e) {
                    throw new RuntimeException(e);
                }
            }
            try {
                ((ServerManager)this.openIdServerManager.get()).sign((AuthSuccess)authResponse);
            }
            catch (ServerException e) {
                throw new RuntimeException(e);
            }
            catch (AssociationException e) {
                throw new RuntimeException(e);
            }
            String destinationUrl = authResponse.getDestinationUrl(true);
            this.responseHandler.sendHttpRedirectToUserAgent(destinationUrl, response);
        }
        ((DialogueBean)this.dialogue.get()).setFinished(true);
    }

    private void writeMessageToResponse(Message message, HttpServletResponse response) {
        Writer writer = this.responseHandler.getWriter("text/plain", response);
        try {
            writer.append(message.keyValueFormEncoding());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

