/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml;

import java.io.Reader;
import java.io.Writer;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.jboss.seam.security.external.EntityBean;
import org.jboss.seam.security.external.JaxbContext;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.EntitiesDescriptorType;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.EntityDescriptorType;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.IndexedEndpointType;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.KeyDescriptorType;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.KeyTypes;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.RoleDescriptorType;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.SSODescriptorType;
import org.jboss.seam.security.external.jaxb.xmldsig.KeyInfoType;
import org.jboss.seam.security.external.jaxb.xmldsig.ObjectFactory;
import org.jboss.seam.security.external.jaxb.xmldsig.X509DataType;
import org.jboss.seam.security.external.saml.SamlExternalEntity;
import org.jboss.seam.security.external.saml.SamlIdpOrSp;
import org.jboss.seam.security.external.saml.SamlServiceType;
import org.jboss.seam.security.external.saml.SamlSigningKey;
import org.jboss.seam.security.external.saml.api.SamlBinding;
import org.jboss.seam.security.external.saml.api.SamlEntityConfigurationApi;

public abstract class SamlEntityBean
extends EntityBean
implements SamlEntityConfigurationApi {
    private Map<String, SSODescriptorType> metaInfo = new HashMap<String, SSODescriptorType>();
    private String entityId;
    private SamlSigningKey samlSigningKey;
    private SamlBinding preferredBinding = SamlBinding.HTTP_Post;
    @Inject
    private ServletContext servletContext;
    @Inject
    @JaxbContext(value={org.jboss.seam.security.external.jaxb.samlv2.metadata.ObjectFactory.class})
    protected JAXBContext metaDataJaxbContext;
    private boolean singleLogoutMessagesSigned = true;
    private boolean wantSingleLogoutMessagesSigned = true;

    public String getServiceURL(SamlServiceType service) {
        return this.createURL(this.servletContext.getContextPath() + "/saml/" + (Object)((Object)this.getIdpOrSp()) + "/" + service.getName());
    }

    @Override
    public String getMetaDataURL() {
        return this.getServiceURL(SamlServiceType.SAML_META_DATA_SERVICE);
    }

    @Override
    public void setEntityId(String entityId) {
        this.entityId = entityId;
    }

    @Override
    public String getEntityId() {
        return this.entityId;
    }

    protected SamlSigningKey getSigningKey() {
        return this.samlSigningKey;
    }

    @Override
    public void setSigningKey(String keyStoreUrl, String keyStorePass, String signingKeyAlias, String signingKeyPass) {
        if (signingKeyPass == null) {
            signingKeyPass = keyStorePass;
        }
        this.samlSigningKey = new SamlSigningKey(keyStoreUrl, keyStorePass, signingKeyAlias, signingKeyPass);
    }

    public boolean isSingleLogoutMessagesSigned() {
        return this.singleLogoutMessagesSigned;
    }

    public void setSingleLogoutMessagesSigned(boolean singleLogoutMessagesSigned) {
        this.singleLogoutMessagesSigned = singleLogoutMessagesSigned;
    }

    public boolean isWantSingleLogoutMessagesSigned() {
        return this.wantSingleLogoutMessagesSigned;
    }

    public void setWantSingleLogoutMessagesSigned(boolean wantSingleLogoutMessagesSigned) {
        this.wantSingleLogoutMessagesSigned = wantSingleLogoutMessagesSigned;
    }

    public abstract SamlIdpOrSp getIdpOrSp();

    @Override
    public abstract SamlExternalEntity getExternalSamlEntityByEntityId(String var1);

    @Override
    public abstract SamlExternalEntity addExternalSamlEntity(Reader var1);

    @Override
    public abstract List<SamlExternalEntity> getExternalSamlEntities();

    protected void readEntitiesDescriptor(Reader reader) {
        try {
            Unmarshaller unmarshaller = this.metaDataJaxbContext.createUnmarshaller();
            JAXBElement o = (JAXBElement)unmarshaller.unmarshal(reader);
            EntitiesDescriptorType entitiesDescriptor = (EntitiesDescriptorType)o.getValue();
            this.readEntitiesDescriptor(entitiesDescriptor);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    private void readEntitiesDescriptor(EntitiesDescriptorType entitiesDescriptor) {
        for (Object object : entitiesDescriptor.getEntityDescriptorOrEntitiesDescriptor()) {
            if (object instanceof EntityDescriptorType) {
                EntityDescriptorType entityDescriptor = (EntityDescriptorType)object;
                this.readEntityDescriptor(entityDescriptor);
                continue;
            }
            EntitiesDescriptorType descriptor = (EntitiesDescriptorType)object;
            this.readEntitiesDescriptor(descriptor);
        }
    }

    private void readEntityDescriptor(EntityDescriptorType entityDescriptor) {
        String entityId = entityDescriptor.getEntityID();
        for (RoleDescriptorType roleDescriptor : entityDescriptor.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor()) {
            this.metaInfo.put(entityId, (SSODescriptorType)roleDescriptor);
        }
    }

    public Map<String, SSODescriptorType> getMetaInfo() {
        return this.metaInfo;
    }

    protected EntityDescriptorType readEntityDescriptor(Reader metaInfoReader) {
        try {
            Unmarshaller unmarshaller = this.metaDataJaxbContext.createUnmarshaller();
            JAXBElement o = (JAXBElement)unmarshaller.unmarshal(metaInfoReader);
            EntityDescriptorType entityDescriptor = (EntityDescriptorType)o.getValue();
            return entityDescriptor;
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public abstract void writeMetaData(Writer var1);

    protected void addKeyDescriptorToMetaData(SSODescriptorType ssoDescriptor) {
        JAXBElement<byte[]> X509Certificate2;
        org.jboss.seam.security.external.jaxb.samlv2.metadata.ObjectFactory metaDataFactory = new org.jboss.seam.security.external.jaxb.samlv2.metadata.ObjectFactory();
        ObjectFactory signatureFactory = new ObjectFactory();
        X509Certificate certificate = this.getSigningKey().getCertificate();
        if (certificate == null) {
            throw new RuntimeException("Certificate obtained from configuration is null");
        }
        try {
            X509Certificate2 = signatureFactory.createX509DataTypeX509Certificate(certificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new RuntimeException(e);
        }
        X509DataType X509Data = signatureFactory.createX509DataType();
        X509Data.getX509IssuerSerialOrX509SKIOrX509SubjectName().add(X509Certificate2);
        KeyInfoType keyInfo = signatureFactory.createKeyInfoType();
        keyInfo.getContent().add(signatureFactory.createX509Data(X509Data));
        KeyDescriptorType keyDescriptor = metaDataFactory.createKeyDescriptorType();
        keyDescriptor.setUse(KeyTypes.SIGNING);
        keyDescriptor.setKeyInfo(keyInfo);
        ssoDescriptor.getKeyDescriptor().add(keyDescriptor);
    }

    protected void addSloEndpointsToMetaData(SSODescriptorType ssoDescriptor) {
        org.jboss.seam.security.external.jaxb.samlv2.metadata.ObjectFactory metaDataFactory = new org.jboss.seam.security.external.jaxb.samlv2.metadata.ObjectFactory();
        IndexedEndpointType sloRedirectEndpoint = metaDataFactory.createIndexedEndpointType();
        sloRedirectEndpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
        sloRedirectEndpoint.setLocation(this.getServiceURL(SamlServiceType.SAML_SINGLE_LOGOUT_SERVICE));
        IndexedEndpointType sloPostEndpoint = metaDataFactory.createIndexedEndpointType();
        sloPostEndpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
        sloPostEndpoint.setLocation(this.getServiceURL(SamlServiceType.SAML_SINGLE_LOGOUT_SERVICE));
        ssoDescriptor.getSingleLogoutService().add(sloRedirectEndpoint);
        ssoDescriptor.getSingleLogoutService().add(sloPostEndpoint);
    }

    protected void addNameIDFormatsToMetaData(SSODescriptorType idpSsoDescriptor) {
        idpSsoDescriptor.getNameIDFormat().add("urn:oasis:names:tc:SAML:2.0:nameid-format:persistent");
        idpSsoDescriptor.getNameIDFormat().add("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
        idpSsoDescriptor.getNameIDFormat().add("urn:oasis:names:tc:SAML:2.0:nameid-format:unspecified");
        idpSsoDescriptor.getNameIDFormat().add("urn:oasis:names:tc:SAML:2.0:nameid-format:emailAddress");
    }

    @Override
    public SamlBinding getPreferredBinding() {
        return this.preferredBinding;
    }

    @Override
    public void setPreferredBinding(SamlBinding preferredBinding) {
        this.preferredBinding = preferredBinding;
    }
}

