/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.Binder;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jboss.seam.security.external.Base64;
import org.jboss.seam.security.external.JaxbContext;
import org.jboss.seam.security.external.ResponseHandler;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.AuthnRequestType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.LogoutRequestType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.ObjectFactory;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.RequestAbstractType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.ResponseType;
import org.jboss.seam.security.external.jaxb.samlv2.protocol.StatusResponseType;
import org.jboss.seam.security.external.saml.SamlDialogue;
import org.jboss.seam.security.external.saml.SamlEndpoint;
import org.jboss.seam.security.external.saml.SamlEntityBean;
import org.jboss.seam.security.external.saml.SamlExternalEntity;
import org.jboss.seam.security.external.saml.SamlIdpOrSp;
import org.jboss.seam.security.external.saml.SamlPostMessage;
import org.jboss.seam.security.external.saml.SamlProfile;
import org.jboss.seam.security.external.saml.SamlRedirectMessage;
import org.jboss.seam.security.external.saml.SamlRequestOrResponse;
import org.jboss.seam.security.external.saml.SamlService;
import org.jboss.seam.security.external.saml.SamlSignatureUtilForPostBinding;
import org.jboss.seam.security.external.saml.SamlSignatureUtilForRedirectBinding;
import org.jboss.seam.security.external.saml.SamlUtils;
import org.jboss.seam.security.external.saml.api.SamlBinding;
import org.jboss.seam.security.external.saml.sp.SamlExternalIdentityProvider;
import org.jboss.solder.logging.Logger;
import org.w3c.dom.Document;

@ApplicationScoped
public class SamlMessageSender {
    @Inject
    private Logger log;
    @Inject
    private Instance<SamlEntityBean> samlEntityBean;
    @Inject
    private SamlSignatureUtilForPostBinding signatureUtilForPostBinding;
    @Inject
    private SamlSignatureUtilForRedirectBinding samlSignatureUtilForRedirectBinding;
    @Inject
    private ResponseHandler responseHandler;
    @Inject
    @JaxbContext(value={RequestAbstractType.class, StatusResponseType.class})
    private JAXBContext jaxbContext;
    @Inject
    private Instance<SamlDialogue> samlDialogue;

    public void sendRequest(SamlExternalEntity samlProvider, SamlProfile profile, RequestAbstractType samlRequest, HttpServletResponse response) {
        Document message = null;
        SamlService service = samlProvider.getService(profile);
        SamlEndpoint endpoint = this.getEndpoint(service);
        try {
            Object requestElement;
            samlRequest.setDestination(endpoint.getLocation());
            if (samlRequest instanceof AuthnRequestType) {
                AuthnRequestType authnRequest = (AuthnRequestType)samlRequest;
                requestElement = new ObjectFactory().createAuthnRequest(authnRequest);
            } else if (samlRequest instanceof LogoutRequestType) {
                LogoutRequestType logoutRequest = (LogoutRequestType)samlRequest;
                requestElement = new ObjectFactory().createLogoutRequest(logoutRequest);
            } else {
                throw new RuntimeException("Currently only authentication and logout requests can be sent");
            }
            Binder binder = this.jaxbContext.createBinder();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setXIncludeAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            message = builder.newDocument();
            binder.marshal(requestElement, (Object)message);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.sendMessage(samlProvider, message, SamlRequestOrResponse.REQUEST, endpoint, response);
    }

    public void sendResponse(SamlExternalEntity samlProvider, StatusResponseType samlResponse, SamlProfile profile, HttpServletResponse response) {
        Document message = null;
        SamlService service = samlProvider.getService(profile);
        SamlEndpoint endpoint = this.getEndpoint(service);
        try {
            samlResponse.setDestination(endpoint.getResponseLocation());
            Object responseElement = endpoint.getService().getProfile().equals((Object)SamlProfile.SINGLE_LOGOUT) ? new ObjectFactory().createLogoutResponse(samlResponse) : new ObjectFactory().createResponse((ResponseType)samlResponse);
            Binder binder = this.jaxbContext.createBinder();
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setXIncludeAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            message = builder.newDocument();
            binder.marshal(responseElement, (Object)message);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        this.sendMessage(((SamlDialogue)this.samlDialogue.get()).getExternalProvider(), message, SamlRequestOrResponse.RESPONSE, endpoint, response);
    }

    public SamlEndpoint getEndpoint(SamlService service) {
        SamlEndpoint endpoint = service.getEndpointForBinding(((SamlEntityBean)this.samlEntityBean.get()).getPreferredBinding());
        if (endpoint == null) {
            endpoint = service.getEndpointForBinding(((SamlEntityBean)this.samlEntityBean.get()).getPreferredBinding() == SamlBinding.HTTP_Post ? SamlBinding.HTTP_Redirect : SamlBinding.HTTP_Post);
        }
        if (endpoint == null) {
            throw new RuntimeException("No endpoint found for profile " + (Object)((Object)service.getProfile()));
        }
        return endpoint;
    }

    private void sendMessage(SamlExternalEntity samlProvider, Document message, SamlRequestOrResponse samlRequestOrResponse, SamlEndpoint endpoint, HttpServletResponse response) {
        this.log.debug((Object)("Sending " + (Object)((Object)samlRequestOrResponse) + ": " + SamlUtils.getDocumentAsString(message)));
        try {
            boolean signMessage = endpoint.getService().getProfile() == SamlProfile.SINGLE_SIGN_ON ? (((SamlEntityBean)this.samlEntityBean.get()).getIdpOrSp() == SamlIdpOrSp.SP ? ((SamlExternalIdentityProvider)samlProvider).isWantAuthnRequestsSigned() : true) : ((SamlEntityBean)this.samlEntityBean.get()).isSingleLogoutMessagesSigned();
            if (endpoint.getBinding() == SamlBinding.HTTP_Redirect) {
                byte[] responseBytes = SamlUtils.getDocumentAsString(message).getBytes("UTF-8");
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                Deflater deflater = new Deflater(8, true);
                DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)baos, deflater);
                deflaterStream.write(responseBytes);
                deflaterStream.finish();
                byte[] deflatedMsg = baos.toByteArray();
                String base64EncodedResponse = Base64.encodeBytes(deflatedMsg, 8);
                PrivateKey privateKey = null;
                if (signMessage) {
                    privateKey = ((SamlEntityBean)this.samlEntityBean.get()).getSigningKey().getPrivateKey();
                }
                this.sendSamlRedirect(base64EncodedResponse, signMessage, samlRequestOrResponse, privateKey, endpoint, response);
            } else {
                if (signMessage) {
                    PublicKey publicKey = ((SamlEntityBean)this.samlEntityBean.get()).getSigningKey().getCertificate().getPublicKey();
                    PrivateKey privateKey = ((SamlEntityBean)this.samlEntityBean.get()).getSigningKey().getPrivateKey();
                    this.signatureUtilForPostBinding.sign(message, new KeyPair(publicKey, privateKey));
                }
                byte[] messageBytes = SamlUtils.getDocumentAsString(message).getBytes("UTF-8");
                String base64EncodedMessage = Base64.encodeBytes(messageBytes, 8);
                SamlPostMessage samlPostMessage = new SamlPostMessage();
                samlPostMessage.setRequestOrResponse(samlRequestOrResponse);
                samlPostMessage.setSamlMessage(base64EncodedMessage);
                samlPostMessage.setRelayState(((SamlDialogue)this.samlDialogue.get()).getExternalProviderRelayState());
                this.responseHandler.sendFormToUserAgent(endpoint.getLocation(), samlPostMessage, response);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void sendSamlRedirect(String base64EncodedSamlMessage, boolean sign, SamlRequestOrResponse samlRequestOrResponse, PrivateKey signingKey, SamlEndpoint endpoint, HttpServletResponse response) {
        SamlRedirectMessage redirectMessage = new SamlRedirectMessage();
        if (sign) {
            try {
                redirectMessage.setRequestOrResponse(samlRequestOrResponse);
                redirectMessage.setSamlMessage(base64EncodedSamlMessage);
                redirectMessage.setRelayState(((SamlDialogue)this.samlDialogue.get()).getExternalProviderRelayState());
                this.samlSignatureUtilForRedirectBinding.sign(redirectMessage, signingKey);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        } else {
            redirectMessage.setRequestOrResponse(samlRequestOrResponse);
            redirectMessage.setSamlMessage(base64EncodedSamlMessage);
        }
        this.responseHandler.sendHttpRedirectToUserAgent(endpoint.getLocation(), redirectMessage, response);
    }
}

