/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.security.external.saml.sp;

import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.enterprise.inject.Typed;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import org.jboss.seam.security.external.SamlMultiUserServiceProviderApi;
import org.jboss.seam.security.external.dialogues.api.Dialogued;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.EntityDescriptorType;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.IDPSSODescriptorType;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.IndexedEndpointType;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.ObjectFactory;
import org.jboss.seam.security.external.jaxb.samlv2.metadata.SPSSODescriptorType;
import org.jboss.seam.security.external.saml.SamlEntityBean;
import org.jboss.seam.security.external.saml.SamlExternalEntity;
import org.jboss.seam.security.external.saml.SamlIdpOrSp;
import org.jboss.seam.security.external.saml.SamlServiceType;
import org.jboss.seam.security.external.saml.api.SamlServiceProviderConfigurationApi;
import org.jboss.seam.security.external.saml.api.SamlSpSession;
import org.jboss.seam.security.external.saml.sp.SamlExternalIdentityProvider;
import org.jboss.seam.security.external.saml.sp.SamlSpBeanApi;
import org.jboss.seam.security.external.saml.sp.SamlSpSessionImpl;
import org.jboss.seam.security.external.saml.sp.SamlSpSessions;
import org.jboss.seam.security.external.saml.sp.SamlSpSingleLogoutService;
import org.jboss.seam.security.external.saml.sp.SamlSpSingleSignOnService;

@Typed(value={SamlSpBean.class})
public class SamlSpBean
extends SamlEntityBean
implements SamlSpBeanApi,
SamlMultiUserServiceProviderApi,
SamlServiceProviderConfigurationApi {
    private List<SamlExternalIdentityProvider> identityProviders = new LinkedList<SamlExternalIdentityProvider>();
    @Inject
    private SamlSpSingleSignOnService samlSpSingleSignOnService;
    @Inject
    private SamlSpSingleLogoutService samlSpSingleLogoutService;
    @Inject
    private SamlSpSessions samlSpSessions;
    private boolean authnRequestsSigned = false;
    private boolean wantAssertionsSigned = false;

    public SamlExternalIdentityProvider addExternalIdentityProvider(String entityId, IDPSSODescriptorType idpSsoDescriptor) {
        SamlExternalIdentityProvider samlIdentityProvider = new SamlExternalIdentityProvider(entityId, idpSsoDescriptor);
        this.identityProviders.add(samlIdentityProvider);
        return samlIdentityProvider;
    }

    @Override
    public SamlExternalIdentityProvider addExternalSamlEntity(Reader reader) {
        EntityDescriptorType entityDescriptor = this.readEntityDescriptor(reader);
        String entityId = entityDescriptor.getEntityID();
        IDPSSODescriptorType IDPSSODescriptor = (IDPSSODescriptorType)entityDescriptor.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor().get(0);
        return this.addExternalIdentityProvider(entityId, IDPSSODescriptor);
    }

    @Override
    public List<SamlExternalEntity> getExternalSamlEntities() {
        LinkedList<SamlExternalEntity> samlEntities = new LinkedList<SamlExternalEntity>();
        for (SamlExternalIdentityProvider idp : this.identityProviders) {
            samlEntities.add(idp);
        }
        return samlEntities;
    }

    @Override
    public List<SamlExternalIdentityProvider> getIdentityProviders() {
        return this.identityProviders;
    }

    @Override
    public boolean isAuthnRequestsSigned() {
        return this.authnRequestsSigned;
    }

    @Override
    public void setAuthnRequestsSigned(boolean authnRequestsSigned) {
        this.authnRequestsSigned = authnRequestsSigned;
    }

    @Override
    public boolean isWantAssertionsSigned() {
        return this.wantAssertionsSigned;
    }

    @Override
    public void setWantAssertionsSigned(boolean wantAssertionsSigned) {
        this.wantAssertionsSigned = wantAssertionsSigned;
    }

    @Override
    public SamlExternalIdentityProvider getExternalSamlEntityByEntityId(String entityId) {
        for (SamlExternalEntity samlExternalEntity : this.identityProviders) {
            SamlExternalIdentityProvider samlIdentityProvider = (SamlExternalIdentityProvider)samlExternalEntity;
            if (!samlIdentityProvider.getEntityId().equals(entityId)) continue;
            return samlIdentityProvider;
        }
        return null;
    }

    @Override
    public void writeMetaData(Writer writer) {
        try {
            ObjectFactory metaDataFactory = new ObjectFactory();
            IndexedEndpointType acsRedirectEndpoint = metaDataFactory.createIndexedEndpointType();
            acsRedirectEndpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            acsRedirectEndpoint.setLocation(this.getServiceURL(SamlServiceType.SAML_ASSERTION_CONSUMER_SERVICE));
            IndexedEndpointType acsPostEndpoint = metaDataFactory.createIndexedEndpointType();
            acsPostEndpoint.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-POST");
            acsPostEndpoint.setLocation(this.getServiceURL(SamlServiceType.SAML_ASSERTION_CONSUMER_SERVICE));
            SPSSODescriptorType spSsoDescriptor = metaDataFactory.createSPSSODescriptorType();
            spSsoDescriptor.getAssertionConsumerService().add(acsRedirectEndpoint);
            spSsoDescriptor.getAssertionConsumerService().add(acsPostEndpoint);
            this.addSloEndpointsToMetaData(spSsoDescriptor);
            spSsoDescriptor.setAuthnRequestsSigned(this.isAuthnRequestsSigned());
            spSsoDescriptor.setWantAssertionsSigned(this.isWantAssertionsSigned());
            spSsoDescriptor.getProtocolSupportEnumeration().add("urn:oasis:names:tc:SAML:2.0:protocol");
            this.addNameIDFormatsToMetaData(spSsoDescriptor);
            if (this.getSigningKey() != null) {
                this.addKeyDescriptorToMetaData(spSsoDescriptor);
            }
            EntityDescriptorType entityDescriptor = metaDataFactory.createEntityDescriptorType();
            entityDescriptor.setEntityID(this.getEntityId());
            entityDescriptor.getRoleDescriptorOrIDPSSODescriptorOrSPSSODescriptor().add(spSsoDescriptor);
            Marshaller marshaller = this.metaDataJaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal(metaDataFactory.createEntityDescriptor(entityDescriptor), writer);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    @Dialogued(join=true)
    public void login(String idpEntityId, HttpServletResponse response) {
        SamlExternalIdentityProvider idp = this.getExternalSamlEntityByEntityId(idpEntityId);
        if (idp == null) {
            throw new RuntimeException("Identity provider " + idpEntityId + " not found");
        }
        this.samlSpSingleSignOnService.sendAuthenticationRequestToIDP(idp, response);
    }

    @Override
    @Dialogued(join=true)
    public void localLogout(SamlSpSession session) {
        this.samlSpSessions.removeSession((SamlSpSessionImpl)session);
    }

    @Override
    @Dialogued(join=true)
    public void globalLogout(SamlSpSession session, HttpServletResponse response) {
        this.localLogout(session);
        this.samlSpSingleLogoutService.sendSingleLogoutRequestToIDP((SamlSpSessionImpl)session, response);
    }

    @Override
    public Set<SamlSpSession> getSessions() {
        HashSet<SamlSpSession> sessions = new HashSet<SamlSpSession>();
        sessions.addAll(this.samlSpSessions.getSessions());
        return sessions;
    }

    @Override
    public SamlIdpOrSp getIdpOrSp() {
        return SamlIdpOrSp.SP;
    }
}

