/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.jboss.seam.social.MultiServicesManager;
import org.jboss.seam.social.SeamSocialExtension;
import org.jboss.seam.social.cdi.RelatedTo;
import org.jboss.seam.social.oauth.OAuthService;

public class MultiServicesManagerImpl
implements MultiServicesManager,
Serializable {
    private static final long serialVersionUID = 2681869484541158766L;
    @Inject
    @Any
    private Instance<OAuthService> serviceInstances;
    @Inject
    private SeamSocialExtension socialConfig;
    private List<String> listOfServices;
    private Set<OAuthService> services = new HashSet<OAuthService>();
    private OAuthService currentService;

    @PostConstruct
    void init() {
        this.listOfServices = new ArrayList<String>(this.socialConfig.getSocialRelated());
    }

    public List<String> getListOfServices() {
        return this.listOfServices;
    }

    public OAuthService getNewService(String serviceName) {
        if (StringUtils.isEmpty((CharSequence)serviceName)) {
            throw new IllegalArgumentException("Empty service name provided");
        }
        if (!this.listOfServices.contains(serviceName)) {
            throw new IllegalArgumentException("Service " + serviceName + " is not available");
        }
        OAuthService service = (OAuthService)this.serviceInstances.select(new Annotation[]{new RelatedTo.RelatedToLiteral(serviceName)}).get();
        return service;
    }

    public Set<OAuthService> getServices() {
        return this.services;
    }

    private void addService(OAuthService service) {
        this.services.add(service);
    }

    public OAuthService getCurrentService() {
        return this.currentService;
    }

    public void setCurrentService(OAuthService currentService) {
        this.currentService = currentService;
    }

    public boolean isCurrentServiceConnected() {
        return this.getCurrentService() != null && this.getCurrentService().isConnected();
    }

    public void connectCurrentService() {
        this.getCurrentService().initAccessToken();
        this.addService(this.getCurrentService());
    }

    public String initNewService(String servType) {
        this.setCurrentService(this.getNewService(servType));
        return this.getCurrentService().getAuthorizationUrl();
    }

    public void destroyCurrentService() {
        if (this.getCurrentService() != null) {
            this.getServices().remove(this.getCurrentService());
            this.getCurrentService().resetConnection();
            this.setCurrentService(this.getServices().size() > 0 ? this.getServices().iterator().next() : null);
        }
    }
}

