/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social;

import java.lang.annotation.Annotation;
import java.util.Map;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.jboss.seam.social.HasStatus;
import org.jboss.seam.social.HttpResponse;
import org.jboss.seam.social.OAuthServiceSettingsImpl;
import org.jboss.seam.social.RestVerb;
import org.jboss.seam.social.SeamSocialException;
import org.jboss.seam.social.UserProfile;
import org.jboss.seam.social.cdi.RelatedTo;
import org.jboss.seam.social.oauth.ConfigureOAuth;
import org.jboss.seam.social.oauth.OAuthProvider;
import org.jboss.seam.social.oauth.OAuthRequest;
import org.jboss.seam.social.oauth.OAuthService;
import org.jboss.seam.social.oauth.OAuthServiceSettings;
import org.jboss.seam.social.oauth.OAuthSessionSettings;
import org.jboss.seam.social.oauth.OAuthToken;
import org.jboss.solder.logging.Logger;

public abstract class OAuthServiceBase
implements OAuthService,
HasStatus {
    private static final long serialVersionUID = -8423894021913341674L;
    private static final String VERIFIER_PARAM_NAME = "oauth_verifier";
    private OAuthServiceSettings settings;
    @Inject
    private OAuthProvider provider;
    @Inject
    private Logger log;
    @Inject
    protected OAuthSessionSettings sessionSettings;
    @Inject
    @Any
    private Instance<OAuthServiceSettings> settingsInstances;
    @Inject
    protected InjectionPoint ip;
    protected UserProfile myProfile;
    private boolean connected = false;
    private String status;

    protected void init() {
        OAuthServiceSettings setting;
        if (this.ip.getAnnotated().isAnnotationPresent(ConfigureOAuth.class)) {
            ConfigureOAuth configureOAuth = (ConfigureOAuth)this.ip.getAnnotated().getAnnotation(ConfigureOAuth.class);
            String apiKey = configureOAuth.apiKey();
            String apiSecret = configureOAuth.apiSecret();
            String callback = configureOAuth.callback();
            String scope = configureOAuth.scope();
            setting = new OAuthServiceSettingsImpl(apiKey, apiSecret, callback, scope, this.getType());
        } else {
            try {
                setting = (OAuthServiceSettings)this.settingsInstances.select(new Annotation[]{new RelatedTo.RelatedToLiteral(this.getType())}).get();
            }
            catch (Exception e) {
                throw new SeamSocialException("Unable to find settings for service " + this.getType(), (Throwable)e);
            }
        }
        this.setSettings(setting);
        this.provider.initProvider(this.settings);
    }

    public OAuthSessionSettings getSession() {
        return this.sessionSettings;
    }

    public void setSession(OAuthSessionSettings session) {
        this.sessionSettings = session;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getName() {
        return this.getType() + " - " + (this.connected ? this.getMyProfile().getFullName() : "not connected");
    }

    public OAuthServiceSettings getSettings() {
        return this.settings;
    }

    public void setSettings(OAuthServiceSettings settings) {
        this.settings = settings;
    }

    public String getAuthorizationUrl() {
        return this.getProvider().getAuthorizationUrl(this.getRequestToken());
    }

    private OAuthProvider getProvider() {
        return this.provider;
    }

    protected OAuthToken getRequestToken() {
        if (this.sessionSettings.getRequestToken() == null) {
            this.sessionSettings.setRequestToken(this.getProvider().getRequestToken());
        }
        return this.sessionSettings.getRequestToken();
    }

    public void initAccessToken() {
        if (this.sessionSettings.getAccessToken() == null) {
            this.sessionSettings.setAccessToken(this.getProvider().getAccessToken(this.getRequestToken(), this.sessionSettings.getVerifier()));
        }
        if (this.sessionSettings.getAccessToken() != null) {
            this.connected = true;
            this.sessionSettings.setRequestToken(null);
            this.initMyProfile();
        }
    }

    protected abstract void initMyProfile();

    public void resetConnection() {
        this.sessionSettings.setAccessToken(null);
        this.sessionSettings.setVerifier(null);
        this.connected = false;
        this.myProfile = null;
    }

    protected HttpResponse sendSignedRequest(OAuthRequest request) {
        this.getProvider().signRequest(this.getAccessToken(), request);
        return request.send();
    }

    public HttpResponse sendSignedRequest(RestVerb verb, String uri) {
        OAuthRequest request = this.provider.requestFactory(verb, uri);
        return this.sendSignedRequest(request);
    }

    public HttpResponse sendSignedRequest(RestVerb verb, String uri, String key, Object value) {
        OAuthRequest request = this.provider.requestFactory(verb, uri);
        request.addBodyParameter(key, value.toString());
        return this.sendSignedRequest(request);
    }

    public HttpResponse sendSignedXmlRequest(RestVerb verb, String uri, String payload) {
        OAuthRequest request = this.provider.requestFactory(verb, uri);
        request.addPayload(payload);
        return this.sendSignedRequest(request);
    }

    public HttpResponse sendSignedRequest(RestVerb verb, String uri, Map<String, Object> params) {
        OAuthRequest request = this.provider.requestFactory(verb, uri);
        for (Map.Entry<String, Object> ent : params.entrySet()) {
            request.addBodyParameter(ent.getKey(), ent.getValue().toString());
        }
        return this.sendSignedRequest(request);
    }

    public void setVerifier(String verifierStr) {
        this.sessionSettings.setVerifier(verifierStr);
    }

    public String getVerifier() {
        return this.sessionSettings.getVerifier();
    }

    public OAuthToken getAccessToken() {
        return this.sessionSettings.getAccessToken();
    }

    public boolean isConnected() {
        return this.connected;
    }

    protected void requireAuthorization() {
        if (!this.isConnected()) {
            throw new SeamSocialException("This action requires an OAuth connexion");
        }
    }

    public void setAccessToken(String token, String secret) {
        this.sessionSettings.setAccessToken(this.provider.tokenFactory(token, secret));
    }

    public void setAccessToken(OAuthToken token) {
        this.sessionSettings.setAccessToken(token);
    }

    public String toString() {
        return this.getName();
    }

    public String getVerifierParamName() {
        return VERIFIER_PARAM_NAME;
    }

    public UserProfile getMyProfile() {
        return this.myProfile;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myProfile == null ? 0 : this.myProfile.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuthServiceBase other = (OAuthServiceBase)obj;
        return !(this.myProfile == null ? other.myProfile != null : !this.myProfile.equals((Object)other.myProfile));
    }
}

