/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social;

import java.io.IOException;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.jboss.seam.social.JsonMapper;
import org.jboss.seam.social.exception.SeamSocialException;
import org.jboss.seam.social.exception.SeamSocialRestException;
import org.jboss.seam.social.rest.RestResponse;

@ApplicationScoped
public class JsonMapperJackson
implements JsonMapper {
    private static final long serialVersionUID = -2012295612034078749L;
    @Produces
    private final ObjectMapper objectMapper = new ObjectMapper();
    @Inject
    @Any
    protected Instance<Module> moduleInstances;

    public <T> T mapToObject(RestResponse resp, Class<T> clazz) {
        try {
            String msg = resp.getBody();
            if (resp.getCode() != 200) {
                throw new SeamSocialRestException(resp.getCode(), resp.getUrl(), msg);
            }
            return (T)this.objectMapper.readValue(msg, clazz);
        }
        catch (IOException e) {
            throw new SeamSocialException("Unable to map Json response", (Throwable)e);
        }
    }

    public String ObjectToJsonString(Object obj) {
        try {
            return this.objectMapper.writeValueAsString(obj);
        }
        catch (Exception e) {
            throw new SeamSocialException("Unable to map a " + obj.getClass().getName() + " to json", (Throwable)e);
        }
    }

    public void registerModule(Module module) {
        this.objectMapper.registerModule(module);
    }

    @PostConstruct
    protected void init() {
        this.objectMapper.enable(new SerializationConfig.Feature[]{SerializationConfig.Feature.WRITE_ENUMS_USING_TO_STRING}).setSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
        this.objectMapper.enable(new DeserializationConfig.Feature[]{DeserializationConfig.Feature.READ_ENUMS_USING_TO_STRING});
        for (Module module : this.moduleInstances) {
            this.registerModule(module);
        }
    }
}

