/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Named;
import org.jboss.seam.social.Current;
import org.jboss.seam.social.MultiServicesManager;
import org.jboss.seam.social.SeamSocialExtension;
import org.jboss.seam.social.SocialNetworkServicesHub;
import org.jboss.seam.social.oauth.OAuthService;
import org.jboss.seam.social.oauth.OAuthSession;
import org.jboss.seam.social.oauth.OAuthSessionImpl;

@SessionScoped
public class MultiServicesManagerImpl
implements MultiServicesManager,
Serializable {
    private static final long serialVersionUID = 2681869484541158766L;
    @Inject
    @Any
    private Instance<OAuthService> serviceInstances;
    @Inject
    @Any
    private Instance<SocialNetworkServicesHub> hubInstances;
    @Inject
    private SeamSocialExtension socialConfig;
    private List<String> listOfServices;
    private final Set<OAuthSession> activeSessions = Sets.newHashSet();
    @Produces
    @Named
    @Current
    private OAuthSession currentSession;

    @PostConstruct
    void init() {
        this.listOfServices = Lists.newArrayList(this.socialConfig.getSocialRelated());
        this.socialConfig.setMultiSession(true);
    }

    public List<String> getListOfServices() {
        return this.listOfServices;
    }

    public OAuthService getCurrentService() {
        return (OAuthService)this.serviceInstances.select(new Annotation[]{this.getCurrentSession().getServiceQualifier()}).get();
    }

    public SocialNetworkServicesHub getCurrentServiceHub() {
        return (SocialNetworkServicesHub)this.hubInstances.select(new Annotation[]{this.getCurrentSession().getServiceQualifier()}).get();
    }

    public boolean isCurrentServiceConnected() {
        return this.getCurrentService() != null && this.getCurrentService().isConnected();
    }

    public synchronized void connectCurrentService() {
        this.getCurrentService().initAccessToken();
        this.activeSessions.add(this.currentSession);
    }

    public String initNewSession(String servType) {
        Annotation qualifier = (Annotation)SeamSocialExtension.getServicesToQualifier().inverse().get((Object)servType);
        this.setCurrentSession(new OAuthSessionImpl(qualifier));
        return this.getCurrentService().getAuthorizationUrl();
    }

    public void destroyCurrentSession() {
        if (this.getCurrentSession() != null) {
            this.activeSessions.remove(this.getCurrentSession());
            this.setCurrentSession(this.activeSessions.size() > 0 ? (OAuthSession)Iterables.getLast(this.activeSessions) : null);
        }
    }

    public void setCurrentSession(OAuthSession currentSession) {
        this.currentSession = currentSession;
    }

    public OAuthSession getCurrentSession() {
        return this.currentSession;
    }

    public Set<OAuthSession> getActiveSessions() {
        return this.activeSessions;
    }
}

