/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.social.oauth;

import java.lang.annotation.Annotation;
import javax.annotation.PostConstruct;
import javax.enterprise.context.SessionScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.seam.social.SocialNetworkServicesHub;
import org.jboss.seam.social.oauth.OAuthApplication;
import org.jboss.seam.social.oauth.OAuthProvider;
import org.jboss.seam.social.oauth.OAuthService;
import org.jboss.seam.social.oauth.OAuthServiceImpl;
import org.jboss.seam.social.oauth.OAuthServiceSettings;
import org.jboss.seam.social.oauth.OAuthServiceSettingsImpl;
import org.jboss.seam.social.oauth.OAuthSession;
import org.jboss.seam.social.oauth.OAuthSessionImpl;
import org.jboss.seam.social.scribe.OAuthProviderScribe;
import org.jboss.solder.bean.generic.ApplyScope;
import org.jboss.solder.bean.generic.Generic;
import org.jboss.solder.bean.generic.GenericConfiguration;
import org.jboss.solder.logging.Logger;

@GenericConfiguration(value=OAuthApplication.class)
public class OAuthGenericManager {
    Annotation qual;
    @Inject
    @Generic
    SocialNetworkServicesHub servicesHub;
    @Inject
    @Generic
    OAuthApplication app;
    @Inject
    Logger log;
    @Produces
    @ApplyScope
    OAuthServiceSettings settings;

    @Produces
    @ApplyScope
    protected OAuthService produceService(OAuthServiceImpl service) {
        service.setQualifier(this.qual);
        this.servicesHub.configureService((OAuthService)service);
        return service;
    }

    @Produces
    @ApplyScope
    public OAuthProvider produceProvider() {
        return new OAuthProviderScribe(this.settings);
    }

    @Produces
    @SessionScoped
    public OAuthSession produceSession() {
        return new OAuthSessionImpl(this.qual);
    }

    @PostConstruct
    void init() {
        this.qual = this.servicesHub.getQualifier();
        this.log.debugf("in OAuthGenericManager creating Hub for %s", (Object)this.qual.toString());
        String apiKey = this.app.apiKey();
        String apiSecret = this.app.apiSecret();
        String callback = this.app.callback();
        String scope = this.app.scope();
        this.settings = new OAuthServiceSettingsImpl(this.qual, apiKey, apiSecret, callback, scope);
    }
}

